% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finalFunctions.R
\name{Mll}
\alias{Mll}
\title{Evaluation of graphs}
\usage{
Mll(Phi, D1, D0, ltype = "marginal", para = c(0.13, 0.05))
}
\arguments{
\item{Phi}{model to be evaluated}

\item{D1}{observed data matrix}

\item{D0}{complementary D1}

\item{ltype}{likelihood type either "marginal" or "maximum"}

\item{para}{false positive and false negative rates}
}
\value{
list with likelihood poster probability, egene positions
}
\description{
Computes marginal log-likelihood
for model Phi given observed data matrix D1
}
\examples{
Phi <- matrix(sample(c(0,1), 9, replace = TRUE), 3, 3)
data <- matrix(sample(c(0,1), 3*10, replace = TRUE), 10, 3)
rownames(Phi) <- colnames(Phi) <- colnames(data) <- c("Ikk1", "Ikk2", "RelA")
score <- Mll(Phi, D1 <- data, D0 <- 1 - data)
}
