% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_results.R
\name{perm.rank.test}
\alias{perm.rank.test}
\title{AUC permutation test}
\usage{
perm.rank.test(
  x,
  y = NULL,
  alternative = c("two.sided", "less", "greater"),
  iter = 1000
)
}
\arguments{
\item{x}{numeric vector of ranks}

\item{y}{numeric vector of the superset of x}

\item{alternative}{character for test type: 'less','greater','two.sided'}

\item{iter}{integer number of iterations}
}
\value{
p-value
}
\description{
computes the area under the rank enrichment score curve and does
a permutation test to compute the p-value
}
\examples{
x <- 1:10
y <- 1:100
perm.rank.test(x,y,alternative='less')
perm.rank.test(x,y,alternative='greater')
}
\author{
Martin Pirkl
}
