% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epimutations_one_leave_out.R
\name{epimutations_one_leave_out}
\alias{epimutations_one_leave_out}
\title{Epimutations analysis based on outlier detection methods}
\usage{
epimutations_one_leave_out(
  methy,
  method = "manova",
  epi_params = epi_parameters(),
  BPPARAM = BiocParallel::SerialParam(),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{methy}{a GenomicRatioSet object
containing the samples for the
analysis. See the constructor function
\link[minfi]{GenomicRatioSet},
\link[minfi]{makeGenomicRatioSetFromMatrix}.}

\item{method}{a character string naming the
outlier detection method to be used.
This can be set as:
\code{"manova"}, \code{"mlm"},
\code{"iForest"}, \code{"mahdist"},
\code{"barbosa"} and \code{beta}.
The default is \code{"manova"}.
For more information see \strong{Details}.}

\item{epi_params}{the parameters for each method.
See the function \link[epimutacions]{epi_parameters}.}

\item{BPPARAM}{(\code{"BiocParallelParam"})
\link[BiocParallel]{BiocParallelParam} object
to configure parallelization execution.
By default, execution is non-parallel.}

\item{verbose}{logical. If TRUE additional
details about the procedure will provide to the user.
The default is TRUE.}

\item{...}{Further parameters passed to \code{epimutations}}
}
\value{
The function returns an object of class tibble
containing the outliers regions.
The results are composed by the following columns:
\itemize{
\item \code{epi_id}: the name of the anomaly detection method that
has been used to detect the epimutation
\item \code{sample}: the name of the sample where the epimutation was found.
\item \code{chromosome}, \code{start} and \code{end}:
indicate the location of the epimutation.
\item \code{sz}: the number of base pairs in the region.
\item \code{cpg_n}: number of CpGs in the region.
\item \code{cpg_ids}: differentially methylated CpGs names.
\item \code{outlier_score}:
\itemize{
\item For method \code{manova} it provides the approximation
to F-test and the Pillai score, separated by \code{/}.
\item For method \code{mlm} it provides the approximation to
F-test and the R2 of the model, separated by \code{/}.
\item For method \code{iForest} it provides the
magnitude of the outlier score.
\item For methods \code{barbosa} and \code{mahdist} is filled with NA.
}
\item \code{outlier_significance}:
\itemize{
\item For methods \code{manova}, \code{mlm}, and \code{iForest}
it provides the p-value obtained from the model.
\item For method \code{barbosa} and \code{mahdist} is filled with NA.
}
\item \code{outlier_direction}: indicates the direction of
the outlier with \code{"hypomethylation"} and \code{"hypermethylation"}
\itemize{
\item For \code{manova}, \code{mlm}, \code{iForest}, and \code{mahdist}
it is computed from the values obtained from bumphunter.
\item For \code{barbosa} it is computed from the location of
the sample in the reference distribution (left vs. right outlier).
}
}
}
\description{
This function is similar to
\link[epimutacions]{epimutations}
with the particularity that when
is more than one case sample,
the remaining case samples are included as controls.
}
\details{
The function compares a case
sample against a control panel
to identify epimutations in the given
sample. First, the DMRs are identified using the
\link[bumphunter]{bumphunter} approach.
After that, CpGs in those DMRs are
tested in order to detect regions
with CpGs being outliers.
For that,  different anomaly
detection methods can be selected:
\itemize{
\item Multivariate Analysis of Variance
(\code{"manova"}). \link[stats]{manova}
\item Multivariate Linear Model (\code{"mlm"})
\item Isolation Forest (\code{"iForest"})
\link[isotree]{isolation.forest}
\item Robust Mahalanobis Distance (\code{"mahdist"})
\link[robustbase]{covMcd}
\item Barbosa (\code{"barbosa"})
}
}
\examples{
data(GRset)
manova_result <- epimutations_one_leave_out(GRset, 
                                            method = "manova")
}
