% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regulonSimilarities.R
\name{findPartners}
\alias{findPartners}
\title{Find interaction partners of a transcription factor of interest}
\usage{
findPartners(graph, focal_tf)
}
\arguments{
\item{graph}{a igraph object from \code{buildGraph} or \code{buildDiffGraph}}

\item{focal_tf}{character string indicating the name of the transcription factors to find
interaction partners of}
}
\value{
A list with elements corresponding to each transcription factor apart from
the focal one. Each list element is represented as a data frame with columns containing
names of all target genes shared with focal transcription factor, weights of edges
connecting transcription factor with target genes, equivalent weights for focal transcription
factor and the element wise product of both weight columns.
}
\description{
Find interaction partners of a transcription factor of interest
}
\examples{
regulon <- data.frame(tf = sample(letters[1:4], 100, replace = TRUE), idxATAC= 1:100,
target = sample(letters[5:14], 100, replace = TRUE))
regulon$weights <- runif(100)
GRN_graph <- buildGraph(regulon)
partners <- findPartners(GRN_graph, 'a')
}
