% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statisticalTests.R
\name{getSigGenes}
\alias{getSigGenes}
\title{Compile and summarize the output from findDifferentialActivity function}
\usage{
getSigGenes(
  da_list,
  fdr_cutoff = 0.05,
  summary_cutoff = NULL,
  topgenes = NULL,
  direction = c("any", "up", "down")
)
}
\arguments{
\item{da_list}{List of dataframes from running findDifferentialActivity}

\item{fdr_cutoff}{A numeric scalar to specify the cutoff for FDR value. Default is 0.05}

\item{summary_cutoff}{A numeric scalar to specify the cutoff for log fold change or difference}

\item{topgenes}{A integer scalar to indicate the number of top ordered genes to include in output}

\item{direction}{A string specifying direction for which differential TF activity was calculated, can be "any", "up" or "down"}
}
\value{
A compiled dataframe of TFs with differential activities across clusters/groups
}
\description{
Compile and summarize the output from findDifferentialActivity function
}
\examples{
set.seed(1)
score.combine <- cbind(matrix(runif(2000,0,2), 20,100), matrix(runif(2000,0,10), 20,100))
rownames(score.combine) <- paste0("TF",1:20)
colnames(score.combine) <- paste0("cell",1:200)
cluster <- c(rep(1,100),rep(2,100))
markers <- findDifferentialActivity(score.combine, cluster, pval.type = "some", direction = "up",
test.type = "t")
sig.genes <- getSigGenes(markers, fdr_cutoff = 1, summary_cutoff = 0.1)
utils::head(sig.genes)
}
\author{
Xiaosai Yao, Shang-yang Chen
}
