% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{plot,EpivizEnvironment,ANY-method}
\alias{plot,EpivizEnvironment,ANY-method}
\title{Generic methods to plot charts and add navigation regions}
\usage{
\S4method{plot}{EpivizEnvironment,ANY}(x, y, ...)
}
\arguments{
\item{x}{an object of type \code{\link{EpivizEnvironment}} or \code{\link{EpivizNavigation}}}

\item{y}{a genomic data object}

\item{...}{other parameters for the plot method}
}
\description{
Generic methods to plot charts and add navigation regions
}
\examples{
\dontrun{
library(epivizrChart)
library(Homo.sapiens)
require(magrittr)

# example data set
data(sumexp)
# create an environment element
epivizEnv <- epivizEnv()

# chain and add navigation regions and plots.
epivizEnv \%>\% 
plot(sumexp, datasource_name="sumExp", columns=c("cancer", "normal")) \%>\% 
append_region(chr="chr11", start=118000000, end=121000000) \%>\% 
plot(sumexp, datasource_name="sumExp", columns=c("normal", "cancer"))
epivizEnv
}
}
