% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EpivizChart-class.R
\docType{class}
\name{EpivizChart-class}
\alias{EpivizChart-class}
\alias{EpivizChart}
\title{Class encapsulating a chart in epiviz app}
\description{
Class encapsulating a chart in epiviz app
}
\section{Methods}{

\describe{
\item{\code{get_app_id(id)}}{Get chart's id assigned by epiviz app.}

\item{\code{get_colors()}}{Get color palette applied to the chart.}

\item{\code{get_id()}}{Get chart's id assigned by chart manager}

\item{\code{get_measurements()}}{Get measurements for the chart.}

\item{\code{get_settings()}}{Get custom settings for the chart.}

\item{\code{get_source_name()}}{Get chart's id assigned by chart manager}

\item{\code{is_connected()}}{Returns \code{TRUE} if chart is connected to a chart on epiviz app.}

\item{\code{print_info()}}{Print settings and color currently used in chart object.}

\item{\code{set(settings = NULL, colors = NULL)}}{Set settings and colors used in chart.
  \describe{
    \item{settings}{List of settings to apply.}
\item{colors}{Character vector of HEX colors to use in chart.}
  }}

\item{\code{set_app_id(id)}}{Set chart's id assigned by epiviz app.}

\item{\code{set_colors(colors)}}{Set custom colors for the chart.}

\item{\code{set_id(id)}}{Set chart's id assigned by chart manager.}

\item{\code{set_settings(settings)}}{Set custom settings for the chart. Returns subset of valid settings.
\describe{
  \item{settings}{List of settings to apply.}
}}
}}

