% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PeakCallingMACS2.R
\name{PeakCallingMACS2}
\alias{PeakCallingMACS2}
\alias{atacPeakCallingMACS2,ATACProc-method}
\alias{atacPeakCallingMACS2}
\alias{peakCallingMACS2}
\alias{testPeakCallingMACS2}
\title{Use MACS2 to call peak}
\usage{
atacPeakCallingMACS2(
  atacProc,
  bedInput = NULL,
  background = NULL,
  outputPrefix = NULL,
  genomeSize = NULL,
  pvalueThreshold = 0.01,
  extsize = 150,
  shift = -round(extsize/2),
  ...
)

\S4method{atacPeakCallingMACS2}{ATACProc}(
  atacProc,
  bedInput = NULL,
  background = NULL,
  outputPrefix = NULL,
  genomeSize = NULL,
  pvalueThreshold = 0.01,
  extsize = 150,
  shift = -round(extsize/2),
  ...
)

peakCallingMACS2(
  bedInput,
  background = NULL,
  outputPrefix = NULL,
  genomeSize = NULL,
  pvalueThreshold = 0.01,
  extsize = 150,
  shift = -round(extsize/2),
  ...
)

testPeakCallingMACS2()
}
\arguments{
\item{atacProc}{\code{\link{ATACProc-class}} object scalar.
It has to be the return value of upstream process:
\code{\link{atacSamToBed}},
\code{\link{atacBedUtils}}.}

\item{bedInput}{\code{Character} scalar.
BED file input path.}

\item{background}{\code{Character} scalar.
background directory default: NULL (none)}

\item{outputPrefix}{\code{Character} scalar.
the output bed file path}

\item{extsize}{\code{Logical} scalar.
verbose output if TRUE.}

\item{shift}{\code{Character} scalar.
wg threshold set default: NULL (calculated)}

\item{...}{Additional arguments, currently unused.}

\item{genomeSize}{\code{Numeric} scalar.
the size of genome}

\item{pvalueThreshold}{\code{Numeric} scalar.
threshold (standard deviations) default: NULL (4.0)}
}
\value{
An invisible \code{\link{ATACProc-class}} object scalar for downstream analysis.
}
\description{
Use  MACS2 installed by to call peak
}
\details{
The parameter related to input and output file path
will be automatically
obtained from \code{\link{ATACProc-class}} object(\code{atacProc}) or
generated based on known parameters
if their values are default(e.g. \code{NULL}).
Otherwise, the generated values will be overwrited.
If you want to use this function independently,
you can use \code{peakCalling} instead.
}
\examples{
library(R.utils)
library(magrittr)
td <- tempdir()
setTmpDir(td)

bedbzfile <- system.file(package="esATAC", "extdata", "chr20.50000.bed.bz2")
bedfile <- file.path(td,"chr20.50000.bed")
bunzip2(bedbzfile,destname=bedfile,overwrite=TRUE,remove=FALSE)

bedUtils(bedInput = bedfile,maxFragLen = 100, chrFilterList = NULL) \%>\%
atacPeakCalling

dir(td)
}
\seealso{
\code{\link{atacSamToBed}}
\code{\link{samToBed}}
\code{\link{atacBedUtils}}
\code{\link{bedUtils}}
}
\author{
Zheng Wei
}
