% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMotifScanPair.R
\name{RMotifScanPair}
\alias{RMotifScanPair}
\alias{atacMotifScanPair,ATACProc-method}
\alias{atacMotifScanPair}
\alias{motifscanpair}
\title{Search Motif Position in Given Regions}
\usage{
atacMotifScanPair(
  atacProc,
  peak1 = NULL,
  peak2 = NULL,
  background = NULL,
  genome = NULL,
  motifs = NULL,
  p.cutoff = 1e-04,
  scanO.dir = NULL,
  prefix = NULL,
  ...
)

\S4method{atacMotifScanPair}{ATACProc}(
  atacProc,
  peak1 = NULL,
  peak2 = NULL,
  background = NULL,
  genome = NULL,
  motifs = NULL,
  p.cutoff = 1e-04,
  scanO.dir = NULL,
  prefix = NULL,
  ...
)

motifscanpair(
  peak1 = NULL,
  peak2 = NULL,
  background = NULL,
  genome = NULL,
  motifs = NULL,
  p.cutoff = 1e-04,
  scanO.dir = NULL,
  prefix = NULL,
  ...
)
}
\arguments{
\item{atacProc}{\code{\link{ATACProc-class}} object scalar.
It has to be the return value of upstream process:
\code{\link{atacPeakComp}}.}

\item{peak1}{peak file path.}

\item{peak2}{peak file path.}

\item{background}{background peak file path.}

\item{genome}{BSgenome object, Default: from \code{\link{getRefRc}}.}

\item{motifs}{either\code{\link{PFMatrix}}, \code{\link{PFMatrixList}},
\code{\link{PWMatrix}}, \code{\link{PWMatrixList}}.}

\item{p.cutoff}{p-value cutoff for returning motifs.}

\item{scanO.dir}{\code{Character} scalar.
the output file directory. This function will use the name in motifs as
the file name to save the motif position information in separate files.}

\item{prefix}{prefix for Output file. Order: peak1, peak2, backgroud.}

\item{...}{Additional arguments, currently unused.}
}
\value{
An invisible \code{\link{ATACProc-class}} object scalar for
downstream analysis.
}
\description{
Search motif position in genome according thr given motif and peak information.
}
\details{
This function scan motif position in a given genome regions.
}
\examples{

\dontrun{
library(R.utils)
library(BSgenome.Hsapiens.UCSC.hg19)
p1bz <- system.file("extdata", "Example_peak1.bed.bz2", package="esATAC")
p2bz <- system.file("extdata", "Example_peak2.bed.bz2", package="esATAC")
peak1_path <- as.vector(bunzip2(filename = p1bz,
destname = file.path(getwd(), "Example_peak1.bed"),
ext="bz2", FUN=bzfile, overwrite=TRUE , remove = FALSE))
peak2_path <- as.vector(bunzip2(filename = p2bz,
destname = file.path(getwd(), "Example_peak2.bed"),
ext="bz2", FUN=bzfile, overwrite=TRUE, remove = FALSE))
peakcom.output <- peakcomp(bedInput1 = peak1_path, bedInput2 = peak2_path,
olap.rate = 0.1)

motif <- readRDS(system.file("extdata", "MotifPFM.rds", package="esATAC"))
output <- atacMotifScanPair(atacProc = peakcom.output,
genome = BSgenome.Hsapiens.UCSC.hg19, motifs = motif)
}

}
\seealso{
\code{\link{atacPeakComp}}
}
\author{
Wei Zhang
}
