% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcaEnrichment.R
\name{pcaEnrichment}
\alias{pcaEnrichment}
\title{Visualize the PCA of Enrichment Values}
\usage{
pcaEnrichment(
  input.data,
  dimRed = NULL,
  x.axis = "PC1",
  y.axis = "PC2",
  facet.by = NULL,
  style = c("point", "hex"),
  add.percent.contribution = TRUE,
  display.factors = FALSE,
  number.of.factors = 10,
  palette = "inferno"
)
}
\arguments{
\item{input.data}{Single-cell object (Seurat / SCE) \strong{or} the raw list
returned by \code{\link{performPCA}}.}

\item{dimRed}{Character. Name of the dimensional-reduction slot to pull from
a single-cell object. Ignored when \code{input.data} is the list output.}

\item{x.axis}{Character. Name of the principal component to display on the
x-axis (e.g., \code{"PC1"}). Default is \code{"PC1"}.}

\item{y.axis}{Character. Name of the principal component to display on the
y-axis (e.g., \code{"PC2"}). Default is \code{"PC2"}.}

\item{facet.by}{Character or \code{NULL}. Metadata column used to facet
the plot.}

\item{style}{Character. Plot style. Options:
\itemize{
  \item \code{"point"} (default): Density-aware scatter plot.
  \item \code{"hex"}: Hexagonal binning.
}}

\item{add.percent.contribution}{Logical. If \code{TRUE}, include percent
variance explained in axis labels. Default is \code{TRUE}.}

\item{display.factors}{Logical. If \code{TRUE}, draw arrows for the top
gene-set loadings. Default is \code{FALSE}.}

\item{number.of.factors}{Integer. Number of loadings to display when
\code{display.factors = TRUE}. Default is \code{10}.}

\item{palette}{Character. Color palette name from
\code{\link[grDevices]{hcl.pals}}. Default is \code{"inferno"}.}
}
\value{
A **ggplot2** object.
}
\description{
This function allows the user to examine the distribution of principal
components computed on the enrichment values.
}
\examples{
GS <- list(Bcells = c("MS4A1", "CD79B", "CD79A", "IGH1", "IGH2"),
           Tcells = c("CD3E", "CD3D", "CD3G", "CD7","CD8A"))
pbmc_small <- SeuratObject::pbmc_small
pbmc_small <- runEscape(pbmc_small, 
                        gene.sets = GS, 
                        min.size = NULL)
                        
pbmc_small <- performPCA(pbmc_small, 
                         assay = "escape")
                         
pcaEnrichment(pbmc_small,
              x.axis = "PC1",
              y.axis = "PC2",
              dimRed = "escape.PCA")

}
