% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatterEnrichment.R
\name{scatterEnrichment}
\alias{scatterEnrichment}
\title{Plot 2D Enrichment Distributions With Density or Hexplots}
\usage{
scatterEnrichment(
  input.data,
  assay = NULL,
  x.axis,
  y.axis,
  facet.by = NULL,
  group.by = NULL,
  color.by = c("density", "group", "x", "y"),
  style = c("point", "hex"),
  scale = FALSE,
  bins = 40,
  point.size = 1.2,
  alpha = 0.8,
  palette = "inferno",
  add.corr = FALSE
)
}
\arguments{
\item{input.data}{Output of \code{\link{escape.matrix}} or a single-cell
object previously processed by \code{\link{runEscape}}.}

\item{assay}{Character. Name of the assay holding enrichment scores when
\code{input.data} is a single-cell object. Ignored otherwise.}

\item{x.axis}{Character. Gene-set name to plot on the x-axis.}

\item{y.axis}{Character. Gene-set name to plot on the y-axis.}

\item{facet.by}{Character or \code{NULL}. Metadata column used to facet
the plot.}

\item{group.by}{Character. Metadata column used when \code{color.by = "group"}.
Defaults to the Seurat/SCE \code{ident} slot when \code{NULL}.}

\item{color.by}{Character. Aesthetic mapped to point color. Options:
\itemize{
  \item \code{"density"} (default): Shade points by local 2-D density.
  \item \code{"group"}: Color by the \code{group.by} metadata column.
  \item \code{"x"}: Apply a continuous gradient based on the x-axis values.
  \item \code{"y"}: Apply a continuous gradient based on the y-axis values.
}}

\item{style}{Character. Plot style. Options:
\itemize{
  \item \code{"point"} (default): Density-aware scatter plot.
  \item \code{"hex"}: Hexagonal binning.
}}

\item{scale}{Logical. If \code{TRUE}, scores are centered and scaled
(Z-score) prior to plotting. Default is \code{FALSE}.}

\item{bins}{Integer. Number of hex bins along each axis when
\code{style = "hex"}. Default is \code{40}.}

\item{point.size}{Numeric. Point size for \code{style = "point"}.
Default is \code{1.2}.}

\item{alpha}{Numeric. Transparency for points or hexbins.
Default is \code{0.8}.}

\item{palette}{Character. Color palette name from
\code{\link[grDevices]{hcl.pals}}. Default is \code{"inferno"}.}

\item{add.corr}{Logical. If \code{TRUE}, add Pearson and Spearman
correlation coefficients to the plot (top-left corner). Default is
\code{FALSE}.}
}
\value{
A \pkg{ggplot2} object.
}
\description{
Visualize the relationship between two enrichment scores at single-cell
resolution. By default, points are shaded by local 2-D density
(\code{color.by = "density"}), but users can instead color by a metadata
column (discrete) or by the raw gene-set scores themselves (continuous).
}
\examples{
gs <- list(
  Bcells = c("MS4A1","CD79B","CD79A","IGH1","IGH2"),
  Tcells = c("CD3E","CD3D","CD3G","CD7","CD8A")
)
pbmc <- SeuratObject::pbmc_small |>
  runEscape(gene.sets = gs, min.size = NULL)

scatterEnrichment(
  pbmc,
  assay     = "escape",
  x.axis    = "Tcells",
  y.axis    = "Bcells",
  color.by  = "group",        
  group.by  = "groups",
  add.corr  = TRUE,
  point.size = 1
)

}
