% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_fill.R, R/add_fill_bin.R
\name{add_fill}
\alias{add_fill}
\alias{add_fill_bin}
\title{Adding fill to highlight the figure in the spatial map}
\usage{
add_fill(p, var, point_size = 2, ...)

add_fill_bin(p, var, bins = 30, point_size = 2.8, fun = sum, ...)
}
\arguments{
\item{p}{a spatial map created by \code{make_escheR()}, with or without
other layers of aesthetics.}

\item{var}{A character(1) with the name of the colData(spe) column that
has the values to be used as the background.}

\item{point_size}{A numeric(1) specifying the size of the spot in the
ggplot. Defaults to 2.}

\item{...}{Reserved for future arguments.}

\item{bins}{numeric vector giving number of bins in both vertical and
horizontal directions. Set to 30 by default.}

\item{fun}{function for summary. See more detail in \link[ggplot2]{stat_summary_hex}}
}
\value{
an ggplot object.
}
\description{
Adding fill to highlight the figure in the spatial map
}
\examples{
library(STexampleData)

spe <- Visium_humanDLPFC()

make_escheR(spe) |>
    add_fill(var = "ground_truth")
}
