% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esetTsne.R
\name{esetTsne}
\alias{esetTsne}
\title{plot a t-SNE of an \linkS4class{eSet} object}
\usage{
esetTsne(
  eset,
  psids = 1:nrow(eset),
  trace = TRUE,
  colorVar = character(),
  color = if (length(colorVar) == 0) "black" else character(),
  shapeVar = character(),
  shape = if (length(shapeVar) == 0) 15 else numeric(),
  sizeVar = character(),
  size = if (length(sizeVar) == 0) {
     ifelse(typePlot[1] == "interactive" &&
    packageInteractivity[1] == "plotly", 20, 2.5)
 } else {
     numeric()
 },
  sizeRange = numeric(),
  alphaVar = character(),
  alpha = if (length(alphaVar) == 0) 1 else numeric(),
  alphaRange = numeric(),
  title = "",
  Rtsne.args = list(perplexity = floor((ncol(eset) - 1)/3), theta = 0.5, dims = 2,
    initial_dims = 50),
  fctTransformDataForInputTsne = NULL,
  symmetryAxes = c("combine", "separate", "none"),
  packageTextLabel = c("ggrepel", "ggplot2"),
  topSamples = 10,
  topSamplesCex = ifelse(typePlot[1] == "interactive" && packageInteractivity[1] ==
    "plotly", 10, 2.5),
  topSamplesVar = character(),
  topSamplesJust = c(0.5, 0.5),
  topSamplesColor = "black",
  includeLegend = TRUE,
  includeLineOrigin = TRUE,
  typePlot = c("static", "interactive"),
  packageInteractivity = c("plotly", "ggvis"),
  figInteractiveSize = c(600, 400),
  ggvisAdjustLegend = TRUE,
  interactiveTooltip = TRUE,
  interactiveTooltipExtraVars = character(),
  returnAnalysis = FALSE,
  returnEsetPlot = FALSE
)
}
\arguments{
\item{eset}{expressionSet (or SummarizedExperiment) object with data}

\item{psids}{featureNames of genes to include in the plot, all by default}

\item{trace}{logical, if TRUE (by default), print some messages during tsne is running}

\item{colorVar}{name of variable (in varLabels of the \code{eset}) used 
for coloring, empty by default}

\item{color}{character or factor with specified color(s) for the points, 
replicated if needed. This is used only if \code{colorVar} is empty.
By default: 'black' if \code{colorVar} is not specified and default 
\code{ggplot} palette otherwise}

\item{shapeVar}{name of variable (in varLabels of the \code{eset}) 
used for the shape, empty by default}

\item{shape}{character or factor with specified shape(s) (pch) for the points, 
replicated if needed. This is used only if \code{shapeVar} is empty.
By default: '15' (filled square) if \code{shapeVar} is not specified 
and default \code{ggplot} shape(s) otherwise}

\item{sizeVar}{name of variable (in varLabels of the \code{eset}) 
used for the size, empty by default}

\item{size}{character or factor with specified size(s) (cex) for the points, 
replicated if needed.
This is used only if \code{sizeVar} is empty.
By default: '2.5' if \code{sizeVar} is not specified (20 for a plotly plot)
and default \code{ggplot} size(s) otherwise}

\item{sizeRange}{size (cex) range used in the plot, possible only 
if the \code{sizeVar} is 'numeric' or 'integer'}

\item{alphaVar}{name of variable (in varLabels of the \code{eset}) 
used for the transparency, empty by default.
This parameter is currently only available for static plot and ggvis (only numeric in this case).}

\item{alpha}{character or factor with specified transparency(s) for the points,
replicated if needed. This is used only if \code{shapeVar} is empty. 
By default: '1' if \code{alphaVar} is not specified and default 
\code{ggplot} alpha otherwise
This parameter is currently only available for static and ggvis.}

\item{alphaRange}{transparency (alpha) range used in the plot, 
possible only if the \code{alphaVar} is 'numeric' or 'integer'
This parameter is currently only available for static and ggvis plot.}

\item{title}{plot title, '' by default}

\item{Rtsne.args}{arguments for the Rtsne function, by default:
perplexite parameter = optimal number of neighbours, 
theta = speed/accuracy trade-off (increase for less accuracy), set to 0.0 for exact TSNE}

\item{fctTransformDataForInputTsne}{function which transform the data in the eSet object before
calling the \code{\link[Rtsne]{Rtsne}} function. 
This should be a function which takes a matrix as input and return a matrix, e.g. the dist function.}

\item{symmetryAxes}{set symmetry for axes, either:
\itemize{
 \item{'combine' (by default): }{both axes are symmetric and with the same limits}
 \item{'separate': }{each axis is symmetric and has its own limits}
 \item{'none': }{axes by default (plot limits)}
}}

\item{packageTextLabel}{package used to label the outlying genes/samples/gene sets,
either \code{ggrepel} (by default, only used if package \code{ggrepel} is available),
or \code{ggplot2}}

\item{topSamples}{numeric indicating which percentile (if <1) or number (if >=1) 
of samples most distant to the origin of the plot to annotate, 
by default: 10 samples are selected
If no samples should be annotated, set this parameter to 0.
Currently available for static plot.}

\item{topSamplesCex}{cex for sample annotation (used when \code{topSamples} > 0)}

\item{topSamplesVar}{variable of the phenoData used to label the samples, 
by default: empty, the sampleNames are used for labelling 
(used when \code{topSample}s > 0)}

\item{topSamplesJust}{text justification for the samples 
(used when \code{topSamples} > 0 and if \code{packageTextLabel} is \code{ggplot2}),
by default: c(0.5, 0.5) so centered}

\item{topSamplesColor}{text color for the samples 
(used when \code{topSamples} > 0), black by default}

\item{includeLegend}{logical if TRUE (by default) include a legend, 
otherwise not}

\item{includeLineOrigin}{if TRUE (by default) include vertical line at 
x = 0 and horizontal line at y = 0}

\item{typePlot}{type of the plot returned, either 'static' (static) or 
interactive' (potentially interactive)}

\item{packageInteractivity}{if \code{typePlot} is 'interactive', 
package used for interactive plot,
either 'plotly' (by default) (by default) or 'ggvis'.}

\item{figInteractiveSize}{vector containing the size of the interactive plot, 
as [width, height]
by default: c(600, 400). This is passed to the \code{width} and 
\code{height} parameters of:
\itemize{
 \item{for plotly plots: }{the \code{\link[plotly]{ggplotly}} function}
 \item{for ggvis plots: }{the \code{ggvis::set_options} function}
}}

\item{ggvisAdjustLegend}{logical, if TRUE (by default) adjust the legends in \code{ggvis} to avoid
overlapping legends when multiple legends}

\item{interactiveTooltip}{logical, if TRUE, add hoover functionality showing
sample annotation (variables used in the plot) in the plot}

\item{interactiveTooltipExtraVars}{name of extra variable(s) 
(in varLabels of the \code{eset}) to add in plotlyEsetPlot to label the samples,
empty by default}

\item{returnAnalysis}{logical, if TRUE (FALSE by default), return also the output of the analysis,
and the outlying samples in the topElements element if any, otherwise only the plot object}

\item{returnEsetPlot}{logical, if TRUE return also the \link{esetPlot} object}
}
\value{
if \code{returnAnalysis} is TRUE, return a list:
\itemize{
 \item{analysis: }{output of the spectral map analysis, whose elements can be given
 to the \code{\link{esetPlotWrapper}} function}
   \itemize{
		\item{dataPlotSamples: }{coordinates of the samples}
		\item{esetUsed: }{expressionSet used in the plot}
	  }
  \item{topElements: }{list with top outlying elements if any, possibly genes, samples and gene sets}
  \item{plot: }{the plot output}
}
otherwise return only the plot
}
\description{
\code{esetTsne} reduces the dimension of the data contained in the \linkS4class{eSet} via t-Distributed Stochastic Neighbor Embedding
 with the \code{\link[Rtsne]{Rtsne}} function and plot the subsequent biplot, possibly with sample annotation contained in the eSet.
}
\examples{
library(ALL)
data(ALL)

## complete example (most of the parameters are optional)

# create custom color palette
colorPalette <- c("dodgerblue", colorRampPalette(c("white","dodgerblue2", "darkblue"))(5)[-1], 
	"red", colorRampPalette(c("white", "red3", "darkred"))(5)[-1])

# create tsne
print(esetTsne(eset = ALL, 
	title = "Acute lymphoblastic leukemia dataset \n Tsne complete",
	colorVar = "BT", color = colorPalette,
	shapeVar = "sex", shape = 15:16,
	sizeVar = "age", sizeRange = c(2, 6),
	symmetryAxes = "separate",
	topSamples = 15, topSamplesVar = "cod", topSamplesColor = "black",
	topSamplesJust = c(1, 0), topSamplesCex = 3)
)
}
\references{
L.J.P. van der Maaten and G.E. Hinton (2008). Visualizing
High-Dimensional Data Using t-SNE. Journal of Machine Learning
Research, 2579--2605
}
\seealso{
the function used internally: \code{\link[Rtsne]{Rtsne}} or \url{http://homepage.tudelft.nl/19j49/t-SNE.html}
 for further explanations about this technique.
}
\author{
Laure Cougnaud
}
