% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse.R, R/unify.R
\name{faers_parse}
\alias{faers_parse}
\title{Parse FAERS Quarterly Data}
\usage{
faers_parse(
  path,
  format = NULL,
  year = NULL,
  quarter = NULL,
  compress_dir = getwd()
)
}
\arguments{
\item{path}{A string specifies the path of FAERS Quarterly Data. You can pass
the FAERS zip file directly, In this way, all files in the zip file will be
extracted in \code{compress_dir}. Or, you can also uncompressed youself, and
passed the directory contained the uncompressed files.}

\item{format}{File format to used, only "ascii" and "xml" are availabe.
Default: "ascii".}

\item{year}{Year of the FAERS Quarterly Data. Coerced into integer, if
\code{NULL}, this will be extracted from path.}

\item{quarter}{String specifies quarter of the FAERS data, if \code{NULL}, this
will be extracted from path.}

\item{compress_dir}{A string specifies the directory to extract files to. It
will be created if necessary.}
}
\value{
A \link{FAERSxml} or \link{FAERSascii} object.
}
\description{
Parse FAERS Quarterly Data
}
\section{Unification}{

For all fields data:
\itemize{
\item All names have been converted to lowercase.
\item Rename "isr" into "primaryid" for periods before 2012q3.
}

Field specific operations:
\itemize{
\item \code{demo}:
\itemize{
\item Rename "gndr_cod" into "gender" for periods before 2014q2.
\item Rename "sex" into "gender" for periods after or equal to 2014q2.
\item Rename "case" and "i_f_cod" into "caseid" and "i_f_code" for legacy aers,
before 2012q3.
\item "age_in_years" was added, measured in years.
\item "country_code" was added (encoded according to the \code{iso2c} standards), it
will be convenient to translate it into other code with
\link[countrycode:countrycode]{countrycode()}.
\item "sex" was added, which recoded "F" as "Female", "M" as "Male" and other
values as \code{NA}.
}
\item \code{ther}:
Rename "drug_seq" into "dsg_drug_seq" for legacy aers, before 2012q3.
\item \code{indi}:
Rename "drug_seq" into "indi_drug_seq" for legacy aers, before 2012q3.
\item \code{outc}:
Rename "outc_code" into "outc_cod" for \verb{2012q4} data
}
}

\examples{
# the files included in the package are sampled
data <- faers_parse(
    system.file("extdata", "aers_ascii_2004q1.zip", package = "faers"),
    compress_dir = tempdir()
)
}
