% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotFragments.R
\name{plotAlignedFrags}
\alias{plotAlignedFrags}
\title{plotAlignedFrags}
\usage{
plotAlignedFrags(
  object,
  outList,
  specID,
  fullRange = TRUE,
  normalize = TRUE,
  ...
)
}
\arguments{
\item{object}{where to keep the mass range of the experiment}

\item{outList}{where to keep the mass spectra; both abundance than m/z}

\item{specID}{a vector containing the index of the spectra to be plotted. Is
referred to outList}

\item{fullRange}{if TRUE uses the mass range of the whole experiment,
otherwise uses only the mass range of each plotted spectum}

\item{normalize}{if TRUE normalize the intensity of the mass peak to 100,
the most abundant is 100\% and the other peaks are scaled consequetially}

\item{...}{further arguments passed to the ‘plot’ command}
}
\description{
Plot the aligned mass spectra
}
\details{
Plot the deconvoluted and aligned mass spectra collected using gatherInfo()
}
\examples{

files <- list.files(path = paste(find.package("gcspikelite"), "data",
                    sep = "/"),"CDF", full = TRUE)
data <- peaksDataset(files[1:4], mz = seq(50, 550), rtrange = c(7.5, 8.5))
## create settings object
mfp <- xcms::MatchedFilterParam(fwhm = 10, snthresh = 5)
cwt <- xcms::CentWaveParam(snthresh = 3, ppm = 3000, peakwidth = c(3, 40),
 prefilter = c(3, 100), fitgauss = FALSE, integrate = 2, noise = 0,
 extendLengthMSW = TRUE, mzCenterFun = "wMean")
data <- addXCMSPeaks(files[1:4], data, settings = mfp)
data
## multiple alignment
ma <- multipleAlignment(data, c(1,1,2,2), wn.gap = 0.5, wn.D = 0.05,
 bw.gap = 0.6, bw.D = 0.2, usePeaks = TRUE, filterMin = 1, df = 50,
 verbose = TRUE, metric = 2, type = 2)

## gather apex intensities
gip <- gatherInfo(data, ma)
gip[[33]]
plotAlignedFrags(object = data, outList = gip, specID = 33)

}
\author{
Riccardo Romoli (riccardo.romoli@unifi.it)
}
\keyword{gatherInfo()}
\keyword{plot()}
