% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{invsplitscale-class}
\alias{invsplitscale-class}
\alias{invsplitscale}
\alias{eval,invsplitscale,missing-method}
\title{Class "invsplitscale"}
\description{
As its name suggests, the inverse split scale transformation class represents
the inverse transformation of a split scale transformation that has a logarithmic scale at 
high values and a linear scale at low values.
}
\details{
The inverse split scale transformation is defined by the function
\deqn{f(parameter,r,maxValue,transitionChannel)  \frac{(parameter-b)}{a}, parameter<=t*a + b}
\deqn{f(parameter,r,maxValue,transitionChannel) = \frac{10^{parameter*\frac{d}{r}}}{c}, parameter > t*a+b }
where 
\deqn{b=\frac{transitionChannel}{2}}
\deqn{d=\frac{2*log_{10}(e)*r}{transitionChannel} + log_{10}(maxValue) }
\deqn{t=10^{log_{10}t}} \deqn{a= \frac{transitionChannel}{2*t}}
\deqn{log_{10}ct=\frac{(a*t+b)*d}{r}} \deqn{c=10^{log_{10}ct}}
}
\section{Slots}{

\describe{
\item{\code{.Data}}{Object of class \code{"function"}.}

\item{\code{r}}{Object of class \code{"numeric"} -- a positive value indicating
the range of the logarithmic part of the dispmlay.}

\item{\code{maxValue}}{Object of class \code{"numeric"} -- a positive value 
indicating the maximum value the transformation is applied to.}

\item{\code{transitionChannel}}{Object of class \code{"numeric"} -- non negative 
value that indicates where to split the linear vs. logarithmic transformation.}

\item{\code{parameters}}{Object of class \code{"transformation"} -- flow parameter
to be transformed.}

\item{\code{transformationId}}{Object of class \code{"character"} -- unique ID to
reference the transformation.}
}}

\note{
The transformation object can be evaluated using the eval method by
passing the data frame as an argument.The transformed parameters are
returned as a matrix with a single column. (See example below)
}
\section{Objects from the Class}{
 Objects can be created by calls to the
constructor
\code{invsplitscale(parameters,r,maxValue,transitionChannel,transformationId)}
}

\section{Extends}{

Class \code{"\linkS4class{singleParameterTransform}"}, directly.

Class \code{"\linkS4class{transform}"}, by class "singleParameterTransform", distance 2.

Class \code{"\linkS4class{transformation}"}, by class "singleParameterTransform", distance 3.

Class \code{"\linkS4class{characterOrTransformation}"}, by class "singleParameterTransform", distance 4.
}

\examples{

  dat <- read.FCS(system.file("extdata","0877408774.B08",package="flowCore"))
  sp1<-invsplitscale("FSC-H",r=512,maxValue=2000,transitionChannel=512)
  transOut<-eval(sp1)(exprs(dat))

}
\references{
Gating-ML Candidate Recommendation for Gating Description in
Flow Cytometry
}
\seealso{
splitscale

Other mathematical transform classes: 
\code{\link{EHtrans-class}},
\code{\link{asinht-class}},
\code{\link{asinhtGml2-class}},
\code{\link{dg1polynomial-class}},
\code{\link{exponential-class}},
\code{\link{hyperlog-class}},
\code{\link{hyperlogtGml2-class}},
\code{\link{lintGml2-class}},
\code{\link{logarithm-class}},
\code{\link{logicletGml2-class}},
\code{\link{logtGml2-class}},
\code{\link{quadratic-class}},
\code{\link{ratio-class}},
\code{\link{ratiotGml2-class}},
\code{\link{sinht-class}},
\code{\link{splitscale-class}},
\code{\link{squareroot-class}},
\code{\link{unitytransform-class}}
}
\author{
Gopalakrishnan N,F.Hahne
}
\concept{mathematical transform classes}
\keyword{classes}
