% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{quadraticTransform}
\alias{quadraticTransform}
\title{Create the definition of a quadratic transformation function to be applied
on a data set}
\usage{
quadraticTransform(transformationId="defaultQuadraticTransform", a = 1, b = 1, c = 0)
}
\arguments{
\item{transformationId}{character string to identify the transformation}

\item{a}{double that corresponds to the quadratic coefficient in the
equation}

\item{b}{double that corresponds to the linear coefficient in the equation}

\item{c}{double that corresponds to the intercept in the equation}
}
\value{
Returns an object of class \code{transform}.
}
\description{
Create the definition of the quadratic Transformation that will be applied
on some parameter via the \code{transform} method.  The definition of this
function is currently x <- a*x\^2 + b*x + c
}
\examples{

samp <- read.FCS(system.file("extdata",
   "0877408774.B08", package="flowCore"))
  quadTrans <- quadraticTransform(transformationId="Quadratic-transformation", a=1, b=1, c=0)
  dataTransform <- transform(samp, transformList('FSC-H', quadTrans))


}
\seealso{
\code{\link{transform-class}}, \code{\link{transform}}

Other Transform functions: 
\code{\link{arcsinhTransform}()},
\code{\link{biexponentialTransform}()},
\code{\link{inverseLogicleTransform}()},
\code{\link{linearTransform}()},
\code{\link{lnTransform}()},
\code{\link{logTransform}()},
\code{\link{logicleTransform}()},
\code{\link{scaleTransform}()},
\code{\link{splitScaleTransform}()},
\code{\link{truncateTransform}()}
}
\author{
N. Le Meur
}
\concept{Transform functions}
\keyword{methods}
