% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_gate-methods.R
\name{transform_gate}
\alias{transform_gate}
\alias{transform_gate.default}
\title{Simplified geometric transformation of gates}
\usage{
\method{transform_gate}{default}(
  obj,
  scale = NULL,
  deg = NULL,
  rot_center = NULL,
  dx = NULL,
  dy = NULL,
  center = NULL,
  ...
)
}
\arguments{
\item{obj}{A Gate-type \code{\link{filter}} object (\code{\linkS4class{quadGate}},
\code{\linkS4class{rectangleGate}}, \code{\linkS4class{ellipsoidGate}}, or \code{\linkS4class{polygonGate}})}

\item{scale}{Either a numeric scalar (for uniform scaling in all dimensions) or numeric vector specifying the factor by 
which each dimension of the gate should be expanded (absolute value > 1) or contracted (absolute value < 1). Negative values 
will result in a reflection in that dimension. 

For \code{rectangleGate} and \code{quadGate} objects, this amounts to simply
scaling the values of the 1-dimensional boundaries. For \code{polygonGate} objects, the values of \code{scale} will be used
to determine scale factors in the direction of each of the 2 dimensions of the gate (\code{scale_gate} is not yet defined
for higher-dimensional \code{polytopeGate} objects). \strong{Important: } For \code{ellipsoidGate} objects, \code{scale}
determines scale factors for the major and minor axes of the ellipse, in that order.}

\item{deg}{An angle in degrees by which the gate should be rotated in the counter-clockwise direction.}

\item{rot_center}{A separate 2-dimensional center of rotation for the gate, if desired. By default, this will
be the center for \code{ellipsoidGate} objects or the centroid for \code{polygonGate} objects. The \code{rot_center} argument 
is currently only supported for \code{polygonGate} objects. It is also usually simpler to perform a rotation and a translation 
individually than to manually specify the composition as a rotation around a shifted center.}

\item{dx}{Either a numeric scalar or numeric vector. If it is scalar, this is just the desired shift of the gate in 
its first dimension. If it is a vector, it specifies both \code{dx} and \code{dy} as \code{(dx,dy)}.
This provides an alternate syntax for shifting gates, as well as allowing shifts of \code{ellipsoidGate} objects
in more than 2 dimensions.}

\item{dy}{A numeric scalar specifying the desired shift of the gate in its second dimension.}

\item{center}{A numeric vector specifying where the center or centroid should be moved (rather than specifiying \code{dx} 
and/or \code{dy})}

\item{\dots}{Assignments made to the slots of the particular Gate-type filter object in the form "<slot_name> = <value>"}
}
\value{
A Gate-type \code{filter} object of the same type as \code{gate}, with the geometric transformations applied
}
\description{
Perform geometric transformations of Gate-type \code{\linkS4class{filter}} objects
}
\details{
This method allows changes to the four filter types defined by simple geometric gates (\code{\linkS4class{quadGate}},
\code{\linkS4class{rectangleGate}}, \code{\linkS4class{ellipsoidGate}}, and \code{\linkS4class{polygonGate}}) using
equally simple geometric transformations (shifting/translation, scaling/dilation, and rotation). The method also
allows for directly re-setting the slots of each Gate-type object. Note that these methods are for manually altering
the geometric definition of a gate. To easily transform the definition of a gate with an accompanyging scale 
transformation applied to its underlying data, see \code{\link[ggcyto]{rescale_gate}}.

First, \code{transform_gate} will apply any direct alterations to the slots of the supplied Gate-type filter object.
For example, if "\code{mean = c(1,3)}" is present in the argument list when \code{transform_gate} is called on a
\code{ellipsoidGate} object, the first change applied will be to shift the \code{mean} slot to \code{(1,3)}. The method
will carry over the dimension names from the gate, so there is no need to provide column or row names with arguments
such as \code{mean} or \code{cov} for \code{ellipsoidGate} or \code{boundaries} for \code{polygonGate}.

\code{transform_gate} then passes the geometric arguments (\code{dx}, \code{dy}, \code{deg}, \code{rot_center}, \code{scale}, 
and \code{center}) to the methods which perform each respective type of transformation:  
\code{\link{shift_gate}}, \code{\link{scale_gate}}, or \code{\link{rotate_gate}}. The order of operations is to first
scale, then rotate, then shift. The default behavior of each operation follows that of its corresponding method but for
the most part these are what the user would expect. A few quick notes:
\itemize{
\item \code{rotate_gate} is not defined for \code{rectangleGate} or \code{quadGate} objects, due to their definition as
having 1-dimensional boundaries.
\item The default center for both rotation and scaling of a \code{polygonGate} is the centroid of the polygon. This
results in the sort of scaling most users expect, with a uniform scale factor not distorting the shape of the original polygon.
}
}
\examples{
\dontrun{
# Scale the original gate non-uniformly, rotate it 15 degrees, and shift it
transformed_gate <- transform_gate(original_gate, scale = c(2,3), deg = 15, dx = 500, dy = -700)

# Scale the original gate (in this case an ellipsoidGate) after moving its center to (1500, 2000)
transformed_gate <- transform_gate(original_gate, scale = c(2,3), mean = c(1500, 2000))
}

}
