% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{truncateTransform}
\alias{truncateTransform}
\title{Create the definition of a truncate transformation function to be applied on
a data set}
\usage{
truncateTransform(transformationId="defaultTruncateTransform", a=1)
}
\arguments{
\item{transformationId}{character string to identify the transformation}

\item{a}{double that corresponds to the value at which to truncate}
}
\value{
Returns an object of class \code{transform}.
}
\description{
Create the definition of the truncate Transformation that will be applied on
some parameter via the \code{transform} method.  The definition of this
function is currently x[x<a] <- a.  Hence, all values less than a are
replaced by a. The typical use would be to replace all values less than 1 by
1.
}
\examples{

samp <- read.FCS(system.file("extdata",
   "0877408774.B08", package="flowCore"))
  truncateTrans <- truncateTransform(transformationId="Truncate-transformation", a=5)
  dataTransform <- transform(samp,transformList('FSC-H', truncateTrans))


}
\seealso{
\code{\link{transform-class}}, \code{\link{transform}}

Other Transform functions: 
\code{\link{arcsinhTransform}()},
\code{\link{biexponentialTransform}()},
\code{\link{inverseLogicleTransform}()},
\code{\link{linearTransform}()},
\code{\link{lnTransform}()},
\code{\link{logTransform}()},
\code{\link{logicleTransform}()},
\code{\link{quadraticTransform}()},
\code{\link{scaleTransform}()},
\code{\link{splitScaleTransform}()}
}
\author{
P. Haaland
}
\concept{Transform functions}
\keyword{methods}
