% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spillover.R
\name{spillover-flowSet}
\alias{spillover-flowSet}
\alias{spillover}
\alias{spillover,flowSet-method}
\title{Compute a spillover matrix from a flowSet}
\usage{
\S4method{spillover}{flowSet}(
  x,
  unstained = NULL,
  fsc = "FSC-A",
  ssc = "SSC-A",
  patt = NULL,
  method = "median",
  stain_match = c("intensity", "ordered", "regexpr"),
  useNormFilt = FALSE,
  prematched = FALSE,
  exact_match = FALSE
)
}
\arguments{
\item{x}{A flowSet of compensation beads or cells}

\item{unstained}{The name or index of the unstained negative control}

\item{fsc}{The name or index of the forward scatter parameter}

\item{ssc}{The name or index of the side scatter parameter}

\item{patt}{An optional regular expression defining which parameters should
be considered}

\item{method}{The statistic to use for calculation. Traditionally, this has
been the median so it is the default. The mean is sometimes more stable.}

\item{stain_match}{Determines how the stain channels are matched with the
compensation controls. See details.}

\item{useNormFilt}{logical Indicating whether to apply a
\code{\link[flowStats]{norm2Filter}} first before computing the spillover}

\item{prematched}{a convenience argument specifying if the channels
have already been matched by spillover_match. This will override the
values of unstained and stain_match with unstained = "unstained" and
stain_match = "regexpr".}

\item{exact_match}{a \code{logical} specifying if we should use "regex" or "exact match" to match column names. 
The spillover_ng will pass exact_match and "regexpr" method will be over-ridden.}
}
\value{
A matrix for each of the parameters
}
\description{
Spillover information for a particular experiment is often obtained by
running several tubes of beads or cells stained with a single color that can
then be used to determine a spillover matrix for use with
\code{\link{compensate}}.\cr\cr
When matching stain channels in \code{x} with the compensation controls, we
provide a few options. If \code{ordered}, we assume the ordering of the
channels in the flowSet object is the same as the ordering of the
compensation-control samples. If \code{regexpr}, we use a regular expression
to match the channel names with the names of each of the compensation control
\code{flowFrame}s (that is, \code{sampleNames(x)}, which will typically be the 
filenames passed to \code{\link{read.FCS}}).
By default, we must "guess" based on the largest statistic for the
compensation control (i.e., the row).\cr\cr
Additionally, matching of channels to compensation control files can
be accomplished using the \code{\link{spillover_match}} method, which allows
the matches to be specified using a csv file. The \link{flowSet} returned
by the \code{spillover_match} method should then be used as the \code{x} argument
to \code{spillover} with \code{prematched = TRUE}.
}
\details{
The algorithm used is fairly simple. First, using the scatter parameters, we
restrict ourselves to the most closely clustered population to reduce the
amount of debris. The selected statistic is then calculated on all
appropriate parameters and the unstained values swept out of the matrix.
Every sample is then normalized to [0,1] with respect to the maximum value
of the sample, giving the spillover in terms of a proportion of the primary
channel intensity.
}
\references{
C. B. Bagwell & E. G. Adams (1993). Fluorescence spectral
overlap compensation for any number of flow cytometry parameters. in: Annals
of the New York Academy of Sciences, 677:167-184.
}
\seealso{
\code{\link{compensate}}, \code{\link{spillover_match}}
}
\author{
B. Ellis, J. Wagner
}
\keyword{methods}
