% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaryAnalysis.R
\name{addbs}
\alias{addbs}
\title{Add background subtraction to a summary data frame}
\usage{
addbs(data, column, baseline_column, baseline = "noYFP")
}
\arguments{
\item{data}{the summary data frame of a flowSet (from
\code{\link{summarizeFlow}} or
\code{\link{flsummary}}) to be used in calculating the background
subtracted column}

\item{column}{the column containing the fluorescent (or other)
measurement to be background subtracted}

\item{baseline_column}{the column containing the identifier of the
rows containing background values}

\item{baseline}{\code{character} the identified or name of representing
background fluorescent values}
}
\value{
A summary data frame with an additional column \code{column_bs}
containing the background subtracted values
}
\description{
Makes a new column from \code{column} with the background value of
a given \code{baseline} control from a chosen identifier column
\code{baseline_column} subtracted from the values of \code{column}.
}
\examples{
dat<-read.flowSet(path=system.file("extdata", "tc_example",
package = "flowTime"),alter.names = TRUE)
annotation <- read.csv(system.file("extdata", "tc_example.csv",
package = "flowTime"))
annotation[which(annotation$treatment == 0), 'strain'] <- 'background'
adat <- annotateFlowSet(dat, annotation)
dat_sum <- summarizeFlow(adat, gated = TRUE,
channel = 'FL1.A')
dat_sum <- addbs(data = dat_sum, column = FL1.Amean,
baseline_column = strain,
baseline = "background")

}
