% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GatingHierarchy_Methods.R,
%   R/GatingSet_Methods.R
\name{gs_pop_get_gate}
\alias{gs_pop_get_gate}
\alias{gh_pop_get_gate}
\alias{getGate}
\alias{getGate,GatingHierarchy,character-method}
\alias{getGate,GatingSet,character-method}
\alias{getGate,GatingSetList,character-method}
\title{Return the flowCore gate definition associated with a node in a GatingHierarchy/GatingSet.}
\usage{
gh_pop_get_gate(obj, y)

gs_pop_get_gate(obj, y)
}
\arguments{
\item{obj}{A \code{GatingHierrarchy} or \code{GatingSet}}

\item{y}{A \code{character} the name or full(/partial) gating path of the node of interest.}
}
\value{
A gate object from \code{flowCore}. Usually a \code{polygonGate}, but may be a \code{rectangleGate}. Boolean gates are represented by a \code{"BooleanGate"} S3 class. This is a list boolean gate definition that references populations in the GatingHierarchy and how they are to be combined logically. If \code{obj} is a \code{GatingSet}, assuming the trees associated with each \code{GatingHierarchy} are identical, then this method will return a list of gates, one for each sample in the \code{GatingSet} corresponding to the same population indexed by \code{y}.
}
\description{
Return the flowCore gate definition object associated with a node in a \code{GatingHierarchy} or \code{GatingSet} object.
}
\examples{
  \dontrun{	#gh is a GatingHierarchy
    gh_pop_get_gate(gh, "CD3") #return the gate for the fifth node in the tree, but fetch it by name.
    #G is a GatingSet
    gs_pop_get_gate(G, "CD3") #return a list of gates for the fifth node in each tree
  }
}
\seealso{
\code{\link{gh_pop_get_data}} \code{\link{gs_get_pop_paths}}
}
