% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_fcs.R
\name{load_cytoframe_from_fcs}
\alias{load_cytoframe_from_fcs}
\title{Read a single FCS file in to a cytoframe}
\usage{
load_cytoframe_from_fcs(
  filename,
  transformation = "linearize",
  which.lines = NULL,
  decades = 0,
  is_h5 = NULL,
  backend = get_default_backend(),
  uri = NULL,
  h5_filename = NULL,
  min.limit = NULL,
  truncate_max_range = TRUE,
  dataset = NULL,
  emptyValue = TRUE,
  num_threads = 1,
  ignore.text.offset = FALSE,
  text.only = FALSE
)
}
\arguments{
\item{filename}{The filename of the single FCS file to be read}

\item{transformation}{A character string that defines the type of
transformation. Valid values are \code{linearize} (default),
\code{linearize-with-PnG-scaling}, or \code{scale}.  The \code{linearize}
transformation applies the appropriate power transform to the data. The
\code{linearize-with-PnG-scaling} transformation applies the appropriate
power transform for parameters stored on log scale, and also a linear
scaling transformation based on the "gain" (FCS $PnG keywords) for
parameters stored on a linear scale. The \code{scale} transformation scales
all columns to \eqn{[0,10^{decades}]}.  defaulting to \eqn{decades=0} as in the FCS4
specification.  A logical can also be used: \code{TRUE} is equal to
\code{linearize} and \code{FALSE}(or \code{NULL}) corresponds to no
transformation.  Also, when the transformation keyword of the FCS header is
set to "custom" or "applied", no transformation will be used.}

\item{which.lines}{Numeric vector to specify the indices of the lines to be
read. If it is NULL, all the records are read. If it is of length 1, a random sample of
the size indicated by \code{which.lines} is read in.}

\item{decades}{When scaling is activated, the number of decades to use for
the output.}

\item{is_h5}{Logical indicating whether the data should be stored in h5 format}

\item{h5_filename}{String specifying a name for the h5 file if \code{is_h5} is TRUE}

\item{min.limit}{The minimum value in the data range that is allowed. Some
instruments produce extreme artifactual values. The positive data range for
each parameter is completely defined by the measurement range of the
instrument and all larger values are set to this threshold. The lower data
boundary is not that well defined, since compensation might shift some
values below the original measurement range of the instrument. This can be 
set to an arbitrary number or to \code{NULL} (the default value), in which 
case the original values are kept.}

\item{truncate_max_range}{Logical. Default is TRUE. can be optionally
turned off to avoid truncating the extreme positive value to the instrument
measurement range, i.e. '$PnR'.}

\item{dataset}{The FCS file specification allows for multiple data segments
in a single file. Since the output of \code{load_cytoframe_from_cytoset} is a single
\code{cytoframe} we can't automatically read in all available sets. This
parameter allows the user to choose one of the subsets for import. Its value should
be an integer in the range of available data sets. This argument
is ignored if there is only a single data segment in the FCS file.}

\item{emptyValue}{Logical indicating whether or not to allow empty values for
keywords in TEXT segment.  It affects how double delimiters are
treated. If TRUE, double delimiters are parsed as a pair of start and
end single delimiters for an empty value.  Otherwise, double delimiters are
parsed as one part of the string of the keyword value. The default is TRUE.}

\item{num_threads}{Integer allowing for parallelization of the parsing
operation by specifiying a number of threads}

\item{ignore.text.offset}{Logical indicating whether to ignore the keyword values in TEXT
segment when they don't agree with the HEADER.  Default is FALSE, which
throws the error when such a discrepancy is found. Users can turn it on to
ignore the TEXT segment when they are sure of the accuracy of the HEADER segment so that the
file still can be read.}

\item{text.only}{whether to only parse text section of FCS (default is FALSE), it is sometime useful to skip loading data section for the faster loading meta data from FCS
\code{\link[Biobase]{read.AnnotatedDataFrame}}, see details}
}
\value{
An object of class
\code{\link{cytoframe}} that contains the data, the parameters monitored, 
and the keywords and values saved in the header of the FCS file.
}
\description{
Similar to \code{\link[flowCore]{read.FCS}}, this takes a filename for a single
FCS file and returns a \code{cytoframe}.
}
\details{
The function \code{load_cytoframe_from_fcs} works with the output of the FACS machine
software from a number of vendors (FCS 2.0, FCS 3.0 and List Mode Data LMD).
However, the FCS 3.0 standard includes some options that are not yet
implemented in this function. If you need extensions, please let us know.
The output of the function is an object of class \code{cytoframe}.

For specifications of FCS 3.0 see \url{http://www.isac-net.org} and the file
\url{../doc/fcs3.html} in the \code{doc} directory of the package.

The \code{which.lines} arguments allow you to read a subset of the record as
you might not want to read the thousands of events recorded in the FCS file.
It is mainly used when there is not enough memory to read one single FCS
(which probably will not happen).  It will probably take more time than
reading the entire FCS (due to the multiple disk IO).
}
\seealso{
Other cytoframe/cytoset IO functions: 
\code{\link{cf_get_uri}()},
\code{\link{cf_write_disk}()},
\code{\link{cf_write_h5}()},
\code{\link{cs_get_uri}()},
\code{\link{load_cytoframe}()},
\code{\link{load_cytoset_from_fcs}()}
}
\concept{cytoframe/cytoset IO functions}
