% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_Methods.R
\name{pop_add}
\alias{pop_add}
\alias{pop_add.filter}
\alias{pop_add.filters}
\alias{pop_add.quadGate}
\alias{pop_add.logical}
\alias{pop_add.factor}
\alias{pop_add.logicalFilterResult}
\alias{pop_add.multipleFilterResult}
\alias{gh_pop_remove}
\title{Add populations to a GatingHierarchy}
\usage{
pop_add(gate, gh, ...)

\method{pop_add}{filter}(gate, gh, ...)

\method{pop_add}{filters}(gate, gh, names = NULL, ...)

\method{pop_add}{quadGate}(gate, gh, names = NULL, ...)

\method{pop_add}{logical}(gate, gh, parent, name, recompute, cluster_method_name = NULL, ...)

\method{pop_add}{factor}(gate, gh, name = NULL, ...)

\method{pop_add}{logicalFilterResult}(gate, gh, ...)

\method{pop_add}{multipleFilterResult}(gate, gh, name = NULL, ...)

gh_pop_remove(gh, node, ...)
}
\arguments{
\item{gate}{a gate object that extends \code{flowCore::filter} or \code{flowCore::filters}}

\item{gh}{GatingHierarchy}

\item{...}{other arguments}

\item{names}{a \code{character} vector of length four,which specifies the population names resulted by adding a \code{quadGate}.The order of the names is clock-wise starting from the top left quadrant population.}

\item{parent}{a \code{character} scalar to specify the parent node name where the new gate to be added to, by default it is NULL,which indicates the root node}

\item{name}{the population name}

\item{recompute}{whether to recompute the gates}

\item{cluster_method_name}{when adding the logical vectors as the gates, the name of the cluster method can be used to tag the populations as the extra meta information associated with the gates.}

\item{node}{population name/path}
}
\description{
Add populations to a GatingHierarchy
}
