% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllMethods.R
\name{fmrs.gendata}
\alias{fmrs.gendata}
\alias{fmrs.gendata,ANY-method}
\alias{fmrs.gendata-method}
\title{fmrs.gendata method}
\usage{
fmrs.gendata(nObs, nComp, nCov, coeff, dispersion, mixProp, rho, umax, ...)

\S4method{fmrs.gendata}{ANY}(
  nObs,
  nComp,
  nCov,
  coeff,
  dispersion,
  mixProp,
  rho,
  umax,
  disFamily = "lnorm"
)
}
\arguments{
\item{nObs}{A numeric value represents sample size}

\item{nComp}{A numeric value represents the order mixture in \code{FMRs}}

\item{nCov}{A numeric value represents the number of covariates in
design matrix}

\item{coeff}{A vector of all regression coefficients including
intercepts. It must be a vector of length
\code{nComp} *(\code{nCov+1}).}

\item{dispersion}{A vector of positive values for dispersion parameters of
sub-distributions in \code{FMRs} models}

\item{mixProp}{A vector of mixing proportions which their sum must be one}

\item{rho}{A numeric value in [-1, 1] which represents the correlation
between covariates of design matrix}

\item{umax}{A numeric value represents the upper bound in Uniform
distribution for censoring}

\item{...}{Other possible options}

\item{disFamily}{A sub-distribution family. The options
are \code{'norm'} for \code{FMR} models, \code{'lnorm'} for mixture of
AFT regression models with Log-Normal sub-distributions,\code{'weibull'}
for mixture of AFT regression models with Weibull sub-distributions}
}
\value{
A list including response, covariates and censoring variables
}
\description{
Generates a data set from Finite Mixture
  of AFT regression models or Finite Mixture of Regression models under
  the specified setting.
}
\examples{
set.seed(1980)
K = 2
D = 10
n = 500
REP = 500
sig = c(1, 1)
piM = c(0.4, 0.6)
r1 = 0.5
coeff1 = c( 2,  2, -1, -2, 1, 2, 0, 0,  0, 0,  0)
coeff2 = c(-1, -1,  1,  2, 0, 0, 0, 0, -1, 2, -2)
Um = 40

dat <- fmrs.gendata(nObs = n, nComp = K, nCov = D, coeff = c(coeff1, coeff2),
dispersion = sig, mixProp = piM, rho = r1, umax = Um, disFamily = 'lnorm')
}
\seealso{
Other lnorm, norm, weibull: 
\code{\link{fmrs.mle}()},
\code{\link{fmrs.tunsel}()},
\code{\link{fmrs.varsel}()}
}
\author{
Farhad Shokoohi <shokoohi@icloud.com>
}
\concept{fmr, aft, censoring, data generation}
\concept{lnorm, norm, weibull}
\keyword{AFT}
\keyword{Censored}
\keyword{Data}
\keyword{FMRs}
\keyword{Generation}
