% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tx.R
\name{gDNAtx}
\alias{gDNAtx}
\title{Remove gDNA contamination from RNA-seq data}
\usage{
gDNAtx(
  x,
  path = ".",
  sbparam = NULL,
  yieldSize = 1000000L,
  verbose = TRUE,
  BPPARAM = SerialParam(progressbar = verbose)
)
}
\arguments{
\item{x}{\linkS4class{gDNAx} object obtained with the function
\code{\link{gDNAdx}()}.}

\item{path}{Directory where to write the filtered BAM files.}

\item{sbparam}{Either \code{NULL} (default) or a
\code{\link[Rsamtools:ScanBamParam-class]{ScanBamParam}} object. The \code{NULL} value
implies that internally a \code{\link[Rsamtools:ScanBamParam-class]{ScanBamParam}} object
is built with the following flags: \code{isUnmappedQuery=FALSE},
\code{isProperPair=!singleEnd(x)}, \code{isSecondaryAlignment=FALSE},
\code{isNotPassingQualityControls=FALSE}, \code{isDuplicate=FALSE}.}

\item{yieldSize}{(Default 1e6) Number of records in the input BAM file to
yield each time the file is read. The lower the value, the smaller memory
consumption, but in the case of large BAM files, values below 1e6 records
may decrease the overall performance.}

\item{verbose}{(Default TRUE) Logical value indicating if progress should be
reported through the execution of the code.}

\item{BPPARAM}{An object of a
\code{\link[BiocParallel:BiocParallelParam-class]{BiocParallelParam}} subclass
to configure the parallel execution of the code. By default, a
\code{\link[BiocParallel:SerialParam-class]{SerialParam}} object is used, which does
not use any parallelization, with the flag \code{progress=TRUE} to show
progress through the calculations.}
}
\value{
A \code{data.frame} object with the number of filtered read alignments
tallied by their origin.
}
\description{
Remove gDNA contamination from RNA-seq data by filtering read alignments in
BAM files that putatively have a gDNA origin. This is currently a wrapper
with convenient default values for the function \code{\link{filterBAMtx}()},
please use that function if you need greater control on how to filter RNA-seq
alignments.
}
\examples{

library(gDNAinRNAseqData)
 
library(TxDb.Hsapiens.UCSC.hg38.knownGene)
txdb <- TxDb.Hsapiens.UCSC.hg38.knownGene

## fetch sample BAM files
bamfiles <- LiYu22subsetBAMfiles()
bamfiles <- bamfiles[c(1,7)] # using a subset of samples

## diagnose gDNA contamination
gdnax <- gDNAdx(bamfiles, txdb, singleEnd=FALSE, strandMode=NA)

## remove gDNA contamination
dir <- tempdir()
fstats <- gDNAtx(gdnax, path=dir)
fstats
list.files(dir, pattern="*.bam$")

}
