% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_annotation.R
\name{get_cell_line_annotation}
\alias{get_cell_line_annotation}
\title{get_cell_line_annotation}
\usage{
get_cell_line_annotation(
  data,
  fname = "cell_lines.csv",
  fill = "unknown",
  annotation_package = if ("gDRinternal" \%in\% .packages(all.available = TRUE)) {
    
    "gDRinternal"
 } else {
     "gDRtestData"
 }
)
}
\arguments{
\item{data}{data.table with cell line identifiers to be matched}

\item{fname}{string with file name containing the annotation}

\item{fill}{string indicating how unknown cell lines should be filled in the DB}

\item{annotation_package}{string indicating name of the package containing cell line annotation}
}
\value{
data.table with cell line annotations
}
\description{
Get cell line annotation data table
}
\examples{
data <- data.table::data.table(clid = c("CL1", "CL2", "CL3"))
cell_line_annotation <- get_cell_line_annotation(data)
}
\keyword{annotation}
