% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_input.R
\name{prepare_input.data.table}
\alias{prepare_input.data.table}
\title{Prepare input data common for all experiments}
\usage{
\method{prepare_input}{data.table}(
  x,
  nested_confounders = gDRutils::get_env_identifiers("barcode"),
  nested_identifiers_l = .get_default_nested_identifiers(),
  ...
)
}
\arguments{
\item{x}{data.table with raw data}

\item{nested_confounders}{Character vector of the nested_confounders for a
given assay. nested_keys is character vector of column names to include in
the data.tables in the assays of the resulting \code{SummarizedExperiment}
object. Defaults to the \code{nested_identifiers} and
\code{nested_confounders} if passed through}

\item{nested_identifiers_l}{list with the
nested_identifiers(character vectors) for \code{single-agent} and (optionally)
for \code{combination} data}

\item{...}{additional parameters}
}
\value{
list of input data
}
\description{
Current steps
\itemize{
\item refining nested confounders
\item refining nested identifiers
\item splitting df_ into (per experiment) df_list
}
}
\keyword{prepare_input}
