% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation.R
\name{getMetabolicPathways}
\alias{getMetabolicPathways}
\title{Generate list of metabolic pathways from Reactome and KEGG databases}
\usage{
getMetabolicPathways(
  universe,
  metGenes,
  keggOrgCode,
  threshold = 0.01,
  includeReactome = TRUE,
  includeKEGG = TRUE
)
}
\arguments{
\item{universe}{list of genes}

\item{metGenes}{list of metabolic genes}

\item{keggOrgCode}{KEGG organism code, like mmu or hsa}

\item{threshold}{threshold for Fisher test to filter out non-metabolic pathways}

\item{includeReactome}{whether to include Reactome pathways (only works for Entrez ID universe)}

\item{includeKEGG}{whether to include KEGG pathways and modules}
}
\value{
list of metabolic pathways for given organism and list of genes
}
\description{
Generate list of metabolic pathways from Reactome and KEGG databases
}
