% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allEndpoints.R
\name{get_dataset_differential_expression_analyses}
\alias{get_dataset_differential_expression_analyses}
\title{Retrieve annotations and surface level stats for a dataset's differential analyses}
\usage{
get_dataset_differential_expression_analyses(
  dataset,
  raw = getOption("gemma.raw", FALSE),
  memoised = getOption("gemma.memoised", FALSE),
  file = getOption("gemma.file", NA_character_),
  overwrite = getOption("gemma.overwrite", FALSE)
)
}
\arguments{
\item{dataset}{A numerical dataset identifier or a dataset short name}

\item{raw}{\code{TRUE} to receive results as-is from Gemma, or \code{FALSE} to enable
parsing. Raw results usually contain additional fields and flags that are
omitted in the parsed results.}

\item{memoised}{Whether or not to save to cache for future calls with the
same inputs and use the result saved in cache if a result is already saved.
Doing \code{options(gemma.memoised = TRUE)} will ensure that the cache is always
used. Use \code{\link{forget_gemma_memoised}} to clear the cache.}

\item{file}{The name of a file to save the results to, or \code{NULL} to not write
results to a file. If \code{raw == TRUE}, the output will be the raw endpoint from the
API, likely a JSON or a gzip file. Otherwise, it will be a RDS file.}

\item{overwrite}{Whether or not to overwrite if a file exists at the specified
filename.}
}
\value{
A data table with information about the differential expression
analysis of the queried dataset. Note that this funciton does not return
differential expression values themselves. Use \code{\link{get_differential_expression_values}}
to get differential expression values (see examples).

The fields of the output data.table are:

\itemize{
\item \code{result.ID}: Result set ID of the differential expression analysis.
May represent multiple factors in a single model.
\item \code{contrast.ID}: Id of the specific contrast factor. Together with the result.ID
they uniquely represent a given contrast.
\item \code{experiment.ID}: Id of the source experiment
\item \code{factor.category}: Category for the contrast
\item \code{factor.category.URI}: URI for the contrast category
\item \code{factor.ID}: ID of the factor
\item \code{baseline.factors}: Characteristics of the baseline. This field is a data.table
\item \code{experimental.factors}: Characteristics of the experimental group. This field is a data.table
\item \code{isSubset}: TRUE if the result set belong to a subset, FALSE if not. Subsets are created when performing differential expression to avoid unhelpful comparisons.
\item \code{subsetFactor}: Characteristics of the subset. This field is a data.table
\item \code{probes.analyzed}: Number of probesets represented in the contrast
\item \code{genes.analyzed}: Number of genes represented in the contrast
}
}
\description{
Retrieve annotations and surface level stats for a dataset's differential analyses
}
\examples{
result <- get_dataset_differential_expression_analyses("GSE2872")
get_differential_expression_values(resultSet = result$result.ID[1])
}
\keyword{dataset}
