% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenericFunctions.R,
%   R/Class_ClassifierParameters.R
\docType{methods}
\name{runClassifier}
\alias{runClassifier}
\alias{runClassifier,character,FixedExpressionData-method}
\alias{runClassifier,ClassifierParameters,FixedExpressionData-method}
\alias{runClassifier,ClassifierResults,FixedExpressionData-method}
\title{Perform classification.}
\usage{
runClassifier(classifierParameters, fixedExpressionData, ...)


  \S4method{runClassifier}{character,FixedExpressionData}(classifierParameters,
  fixedExpressionData, ...)


  \S4method{runClassifier}{ClassifierParameters,FixedExpressionData}(classifierParameters,
  fixedExpressionData, ...)
}
\arguments{
\item{classifierParameters}{Either a text value indicating a
classifier name (see \code{\link{showClassifierList}}), or an
object of class \link{ClassifierParameters} as returned by the
\code{\link{getClassifier}} function.}

\item{fixedExpressionData}{The data to be classified in the
form of a \code{\link{FixedExpressionData}} object as returned
by the \code{\link{setNormalizationMethod}} function.}

\item{...}{see details}
}
\value{
The classification results as an object of class
\code{\link{ClassifierResults}}.
}
\description{
\code{runClassifier} performs classification by applying a
classifier to gene expression data.
}
\details{
A list of possible classifiers is obtained by
\code{\link{showClassifierList}}. The data to be classified
is first to be processed by the \link{setNormalizationMethod}
function. By default the data is assumed to contain many (n>=25)
samples with corresponding probe-sets needed for classification.
If one of these conditions is not met, a classifier outcome might
be seriously affected. By default an error is given. Although
strongly discouraged, it is possible to circumvent the security
checks. If not all required probe-sets are included in the input
set, you can explicitly pass the parameter \code{allow.reweighted = TRUE}
to the \code{runClassifier} function in order to determine the
classifier outcome using less probe-sets (e.g. possible if the
missing probe-sets are known to have minimal contribution).See
\code{vignette("MissingCovariates")} for more information. If
the input data has a small number of samples, the default batch
correction becomes ineffective. If you are aware of the possible
negative effects you can force to not use batch correction by
passing the parameter \code{do.batchcorrection=FALSE}.
}
\examples{
data(exampleMAS5)
myData<-setNormalizationMethod(exampleMAS5,"MAS5.0",targetValue=500)
runClassifier("EMC92",myData)
}
\seealso{
Other workflow functions: \code{\link{getNormalizationMethod}},
  \code{\link{setNormalizationMethod}},
  \code{\link{showClassifierList}}
}
\concept{workflow functions}
