% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoreMatrixList.R
\docType{methods}
\name{orderBy}
\alias{orderBy}
\alias{orderBy,ScoreMatrixList-method}
\title{Reorder all elements of a ScoreMatrixList to a given ordering vector}
\usage{
orderBy(sml, ord.vec)

\S4method{orderBy}{ScoreMatrixList}(sml, ord.vec)
}
\arguments{
\item{sml}{\code{ScoreMatrixList} object}

\item{ord.vec}{an integer vector}
}
\value{
\code{ScoreMatrixList} object
}
\description{
Reorder all elements of a ScoreMatrixList to a given ordering vector
}
\examples{
library(GenomicRanges)
data(cage)
data(cpgi)
data(promoters)

cage$tpm = NULL
targets = GRangesList(cage=cage, cpgi=cpgi)
sml = ScoreMatrixList(targets, promoters, bin.num=10)
kmeans.clust = kmeans(sml$cage,3)
 
sml.ordered = orderBy(sml, kmeans.clust$cluster)
\donttest{
multiHeatMatrix(sml.ordered)
}
}
