% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_hvline.R
\name{geom_hvline}
\alias{geom_hvline}
\title{Vertical or horizontal line.}
\usage{
geom_hvline(
  mapping = NULL,
  data = NULL,
  position = "identity",
  show.legend = FALSE,
  ...
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link{aes}} or \code{\link{aes_string}}. Only needs to be set
at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{position}{The position adjustment to use for overlapping points
on this layer}

\item{show.legend}{should a legend be drawn? (defaults to \code{FALSE})}

\item{...}{other arguments passed on to \code{\link{layer}}. This can
include aesthetics whose values you want to set, not map. See
\code{\link{layer}} for more details.}
}
\value{
a geom_hvline layer
}
\description{
This geom is based on the source code of ' \code{\link{geom_hline}} and \code{\link{geom_vline}}.
}
\details{
The goal is to determine the line to be either vertial or horizontal based on the 1-d data provided in
this layer.
}
\section{Aesthetics}{

\Sexpr[results=rd,stage=build]{ggplot2:::rd_aesthetics("geom", "vline")}
}

\examples{


p <- ggplot(mtcars, aes(x = wt, y = mpg)) + geom_point()
# vline
p + geom_hvline(data = data.frame(wt= 3))
# hline
p + geom_hvline(data = data.frame(mpg= 20))
}
