% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggkegg.R
\name{rawMap}
\alias{rawMap}
\title{rawMap}
\usage{
rawMap(
  enrich,
  pathway_number = 1,
  pid = NULL,
  fill_color = "red",
  how = "any",
  white_background = TRUE,
  infer = FALSE,
  name = "name",
  sep = " ",
  remove_dot = TRUE
)
}
\arguments{
\item{enrich}{enrichResult or gseaResult class object, or list of them}

\item{pathway_number}{pathway number sorted by p-values}

\item{pid}{pathway id, override pathway_number if specified}

\item{fill_color}{color for genes}

\item{how}{how to match the node IDs with the queries 'any' or 'all'}

\item{white_background}{fill background color white}

\item{infer}{if TRUE, append the prefix to queried IDs based on pathway ID}

\item{name}{name of column to match for}

\item{sep}{separater for name, default to " "}

\item{remove_dot}{remove "..." in the name}
}
\value{
ggraph with overlaid KEGG map
}
\description{
given enrichResult class object,
return the ggplot object with raw KEGG map overlaid on
enriched pathway. Can be used with the function such as 
`clusterProfiler::enrichKEGG` and `MicrobiomeProfiler::enrichKO()`
}
\examples{
if (require("clusterProfiler")) {
    cp <- enrichKEGG(c("1029","4171"))
    ## Multiple class object can be passed by list
    rawMap(list(cp,cp), pid="hsa04110")
}
}
