% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.tStat.R
\name{boot.tStat}
\alias{boot.tStat}
\title{Studentized Sorensen-Dice dissimilarity statistic}
\usage{
boot.tStat(xBoot, dis)
}
\arguments{
\item{xBoot}{either an object of class "table", "matrix" or "numeric" representing
a 2x2 contingency table of joint enrichment.}

\item{dis}{the "known" value of the population dissimilarity.}
}
\value{
A numeric value, the result of computing (^dis - dis) / ^se.
}
\description{
Efficient computation of the studentized statistic (^dis - dis) / ^se where 'dis' stands
for the "population" value of the Sorensen-Dice dissimilarity, '^dis' for its estimated
value and '^se'for the estimate of the standard error of '^dis'. Internally used in
bootstrap computations.
}
\details{
This function is repeatedly evaluated during bootstrap iterations.
Given a contingency table 'x' of mutual enrichment (the "true" dataset):

\tabular{rr}{
\eqn{n_{11}} \tab \eqn{n_{10}} \cr
\eqn{n_{01}} \tab \eqn{n_{00}},
}

summarizing the status of mutual presence of enrichment in two gene lists, where
the subindex '11' corresponds to those GO terms enriched in both lists,
'01' to terms enriched in the second list but not in the first one,
'10' to terms enriched in the first list but not enriched in the second one and
'00' to those GO terms non enriched in both gene lists, i.e., to the double negatives.

A typical bootstrap iteration consists in repeatedly generating four frequencies
from a multinomial of parameters size = sum(n_ij), i,j = 1, 0 and probabilities
(n_11/size, n_10/size, n_10/size, n_00/size).
The argument 'xBoot' corresponds to each one of these bootstrap resamples (indiferenly
represented in form of a 2x2 "table" or "matrix" or as a numeric vector)
In each bootstrap iteration, the value of the "true" known 'dis' is the dissimilarity
which was computed from 'x' (a constant, known value in the full iteration) and the
values of '^dis' and '^se' are internally computed from the bootstrap data 'xBoot'.
}
