\name{binnedAFs}
\alias{binnedAFs}
\title{
Estimate allelic frequency distributions in bins along the genome
}
\description{
This function is used to give estimates of the ditribution of observed allelic freuqencies in a regions of the genome, use in conjunction with \code{h5dapply}
}
\usage{
binnedAFs(data, sampledata, normalise = TRUE, binWidth = 0.05, minCov = 10, minCount = 2)
}
\arguments{
  \item{data}{
  A \code{list} object returned by a call to \code{h5dapply} or \code{h5readBlock}.
}
  \item{sampledata}{
  Sample metadata describing the cohort, can be extracted from an HDF5 tally file using the \code{getSampleData} function.
}
  \item{normalise}{
  Boolean flag to specify whether the counts or percentages of observed allelic frequencies should be returned.
}
  \item{binWidth}{
  Width of bins in allelic frequency space, defaults to 0.05.
}
  \item{minCov}{
  Minimum required coverage for a position to be considered.
  }
  \item{minCount}{
  Minimum required number of mismatches for a position to be considered.
}
}

\value{
A matrix of AF bins times samples.
}
\author{
Paul Theodor Pyl
}
\examples{
library(h5vc)
tallyFile <- system.file( "extdata", "example.tally.hfs5", package = "h5vcData" )
sampleData <- getSampleData( tallyFile, "/ExampleStudy/16" )
afs <- h5dapply(
  filename = tallyFile,
  group = "/ExampleStudy/16",
  names = c("Counts", "Coverages"),
  range = c(29e6, 29.05e6),
  blocksize = 1e4,
  FUN = binnedAFs,
  sampledata = sampleData
)
afs[[3]]
}