\name{plotMutationSpectrum}
\alias{plotMutationSpectrum}
\title{Plotting a mutation spectrum}
\description{
This function generates a mutation spectrum plot from a mutation spectrum returned by a call to \code{mutationSPectrum}
}
\usage{
plotMutationSpectrum( ms, plotCounts = TRUE )}
\arguments{
\item{ms}{A mutation spectrum as returned by \code{\link{mutationSpectrum}}}
\item{plotCounts}{Boolean flag specifying whether \code{ms} contains one row per variant (default) or already contains summarized counts per type of mutation}
}
\details{
The plot is inspired by the one shown in figure 1b of \code{Signatures of mutational processes in human cancer -- Alexandrov et. al.}
}
\value{
A ggplot object containing the mutation spectrum plot
}
\author{
Paul Pyl
}
\examples{
  library(h5vc)
  tallyFile <- system.file( "extdata", "example.tally.hfs5", package = "h5vcData" )
  data( "example.variants", package = "h5vcData" )
  plotMutationSpectrum( mutationSpectrum( variantCalls, tallyFile, "/ExampleStudy" ) )
}
