\name{prepareForHDF5}
\alias{prepareForHDF5}
\title{Preparing the results of tallyBAM for writing to an HDF5 tally file}
\description{
This function prepares the resulting array of a call to \code{tallyBAM} for writing to an HDF5 tally file.
}
\usage{
prepareForHDF5( counts, reference )
}
\arguments{
\item{counts}{An array as produced by a call to \code{\link{tallyBAM}}}
\item{reference}{A DNAString object containing the reference sequence corresponding to the region that is described in the counts array -- if this is \code{NULL} a consensus vote will be used to estimate the reference at any given position, this means you cannot detect variants with AF >= 0.5 anymore}
}
\details{
This function performs the neccessary transformation to the \code{array} returned by \code{\link{tallyBAM}} to be compatible with the HDF5 tally file data structure. 
}
\value{
  A list with slots containing the \code{Counts},\code{Coverages},\code{Deletions} and \code{Reference} datasets for the given sample.
}
\author{
Paul Pyl
}
\examples{
library(h5vc)
library(BSgenome.Hsapiens.UCSC.hg19)
files <- c("NRAS.AML.bam","NRAS.Control.bam")
bamFiles <- file.path( system.file("extdata", package = "h5vcData"), files)
chrom = "1"
startpos <- 115247090
endpos <- 115259515
theData <- lapply( bamFiles, function(bamf){
  tallyBAM( file = bamf, chr = chrom, start = startpos, stop = endpos, ncycles = 10 )
})
reference <- getSeq(BSgenome.Hsapiens.UCSC.hg19, "chr1", startpos, endpos)
theData <- lapply(theData, prepareForHDF5, reference)
str(theData)
}
