% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca.R
\docType{class}
\name{calc_pca}
\alias{calc_pca}
\alias{HermesDataPca-class}
\alias{.HermesDataPca}
\alias{HermesDataPca}
\title{Principal Components Analysis Calculation}
\usage{
calc_pca(object, assay_name = "counts", n_top = NULL)
}
\arguments{
\item{object}{(\code{AnyHermesData}) \cr input.}

\item{assay_name}{(\code{string}) \cr name of the assay to use.}

\item{n_top}{(\code{count} or \code{NULL})\cr filter criteria based on number of genes with maximum variance.}
}
\value{
A \link{HermesDataPca} object which is an extension of the \link[stats:prcomp]{stats::prcomp} class.
}
\description{
The \code{calc_pca()} function performs principal components analysis of the gene count
vectors across all samples.

A corresponding \code{autoplot()} method then can visualize the results.
}
\details{
\itemize{
\item PCA should be performed after filtering out low quality genes and samples, as well as
normalization of counts.
\item In addition, genes with constant counts across all samples are excluded from
the analysis internally in \code{calc_pca()}. Centering and scaling is also applied internally.
\item Plots can be obtained with the \code{\link[ggplot2:autoplot]{ggplot2::autoplot()}} function
with the corresponding method from the \code{ggfortify} package to plot the
results of a principal components analysis saved in a \code{\link{HermesDataPca}}
object. See \code{\link[ggfortify:autoplot.pca_common]{ggfortify::autoplot.prcomp()}} for details.
}
}
\examples{
object <- hermes_data \%>\%
  add_quality_flags() \%>\%
  filter() \%>\%
  normalize()

result <- calc_pca(object, assay_name = "tpm")
summary(result)

result1 <- calc_pca(object, assay_name = "tpm", n_top = 500)
summary(result1)

# Plot the results.
autoplot(result)
autoplot(result, x = 2, y = 3)
autoplot(result, variance_percentage = FALSE)
autoplot(result, label = TRUE, label.repel = TRUE)
}
\seealso{
Afterwards correlations between principal components
and sample variables can be calculated, see \code{\link{pca_cor_samplevar}}.
}
