% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quality.R
\name{control_quality}
\alias{control_quality}
\title{Control for Specified Quality Flags}
\usage{
control_quality(
  min_cpm = 1,
  min_cpm_prop = 0.25,
  min_corr = 0.5,
  min_depth = NULL
)
}
\arguments{
\item{min_cpm}{(non-negative \code{number})\cr minimum Counts per Million (\code{CPM}) for
each gene within the sample.}

\item{min_cpm_prop}{(\code{proportion})\cr minimum proportion of samples with
acceptable \code{CPM} of certain gene for low expression flagging.}

\item{min_corr}{(\code{proportion})\cr minimum Pearson correlation coefficient of
\code{CPM} between samples for technical failure flagging.}

\item{min_depth}{(non-negative \code{count} or \code{NULL})\cr minimum library depth
for low depth flagging. If \code{NULL}, this will be calculated as the first
quartile minus 1.5 times the inter-quartile range of the library size
(depth) of all samples. (So anything below the usual lower boxplot whisker
would be too low.)}
}
\value{
List with the above criteria to flag observations.
}
\description{
Control function which specifies the quality flag settings.
One or more settings can be customized. Not specified settings are left at defaults.
}
\note{
To be used with the \code{\link[=add_quality_flags]{add_quality_flags()}} function.
}
\examples{
# Default settings.
control_quality()

# One or more settings can be customized.
control_quality(min_cpm = 5, min_cpm_prop = 0.001)
}
