% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pd.R
\docType{methods}
\name{plotProbDist}
\alias{plotProbDist}
\alias{plotProbDist,matrix-method}
\alias{plotProbDist,SpatialExperiment-method}
\title{Plot probability distribution}
\usage{
plotProbDist(object, ...)

\S4method{plotProbDist}{matrix}(object, targetCells = NA, ...)

\S4method{plotProbDist}{SpatialExperiment}(
  object,
  pm_cols,
  targetCells = NA,
  by_cluster = FALSE,
  show_clusters = as.character(seq(6)),
  plot_all = FALSE,
  sample_size = 2,
  val_name = "clusters",
  ...
)
}
\arguments{
\item{object}{A probability matrix or SpatialExperiment.}

\item{...}{aesthetic mappings to pass to \code{ggplot2::aes_string()}.}

\item{targetCells}{Character. Optional. Can speicify one or more cells to be plotted.}

\item{pm_cols}{The colnames of probability matrix. This is requires for
SpatialExperiment input. Assuming that the probability is stored in the colData.}

\item{by_cluster}{Logical. By default is TRUE, to plot distribution by each cluster.}

\item{show_clusters}{Character. The cluster to be ploted, by default is 1 to 6.}

\item{plot_all}{Logical. By default is FALSE, set this to true to plot box
plot instead of bar plot to show all cells in each cluster.}

\item{sample_size}{Integer. By default is 2, sampling two cell from each
cluster to be plotted.}

\item{val_name}{Character. Column name used to store the clusters.}
}
\value{
A ggplot object.
}
\description{
Plot probability distribution
}
\examples{

data("spe_test")

spe <- readHoodData(spe, anno_col = "celltypes")

fnc <- findNearCells(spe, k = 100)

pm <- scanHoods(fnc$distance)

pm2 <- mergeByGroup(pm, fnc$cells)

spe <- mergeHoodSpe(spe, pm2)

plotProbDist(spe, pm_cols = colnames(pm2))

}
