% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyp_hmap.R
\name{hyp_hmap}
\alias{hyp_hmap}
\title{Visualize hyp/multihyp objects as a hiearchy map}
\usage{
hyp_hmap(
  hyp_obj,
  pval = 1,
  fdr = 1,
  val = c("fdr", "pval"),
  top = NULL,
  title = "",
  graph = FALSE
)
}
\arguments{
\item{hyp_obj}{A hyp or multihyp object}

\item{pval}{Filter results to be less than pval cutoff}

\item{fdr}{Filter results to be less than fdr cutoff}

\item{val}{Choose significance value displayed when hovering nodes e.g. c("fdr", "pval")}

\item{top}{Limit number of pathways shown}

\item{title}{Plot title}

\item{graph}{Return an igraph object instead}
}
\value{
A visNetwork object
}
\description{
Visualize hyp/multihyp objects as a hiearchy map
}
\examples{
genesets <- hyperdb_rgsets("REACTOME", "70.0")

signature <- c("IDH3B","DLST","PCK2","CS","PDHB","PCK1","PDHA1","LOC642502",
               "PDHA2","LOC283398","FH","SDHD","OGDH","SDHB","IDH3A","SDHC",
               "IDH2","IDH1","OGDHL","PC","SDHA","SUCLG1","SUCLA2","SUCLG2")

hyp_obj <- hypeR(signature, genesets, background=2522)

hyp_hmap(hyp_obj, top=60)

}
