% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/COBRAPerformance.R,
%   R/COBRAPlot.R
\docType{methods}
\name{maxsplit}
\alias{maxsplit}
\alias{maxsplit<-}
\alias{maxsplit,COBRAPerformance-method}
\alias{maxsplit<-,COBRAPerformance,numeric-method}
\alias{maxsplit,COBRAPlot-method}
\alias{maxsplit<-,COBRAPlot,numeric-method}
\title{Accessor and replacement functions for \code{maxsplit} slot}
\usage{
maxsplit(x, ...)

maxsplit(x, ...) <- value

\S4method{maxsplit}{COBRAPerformance}(x)

\S4method{maxsplit}{COBRAPerformance,numeric}(x) <- value

\S4method{maxsplit}{COBRAPlot,numeric}(x) <- value
}
\arguments{
\item{x}{A \code{COBRAPerformance} or \code{COBRAPlot} object.}

\item{...}{Additional arguments.}

\item{value}{A numeric value giving the maximal number of strata to retain.}
}
\value{
The accessor function returns a numeric value giving the maximal
  number of strata to retain.
}
\description{
Accessor and replacement functions for the \code{maxsplit} slot in a
\code{COBRAPerformance} or \code{COBRAPlot} object.
}
\examples{
data(cobradata_example)
cobraperf <- calculate_performance(cobradata_example,
                                   binary_truth = "status",
                                   aspects = "fdrtpr", splv = "expr_cat",
                                   maxsplit = 3)
maxsplit(cobraperf)
}
\author{
Charlotte Soneson
}
