% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_methods.R
\name{plot_fdrnbrcurve}
\alias{plot_fdrnbrcurve}
\title{Plot number of significant features vs FDR}
\usage{
plot_fdrnbrcurve(
  cobraplot,
  title = "",
  stripsize = 15,
  titlecol = "black",
  pointsize = 5,
  xaxisrange = c(0, 1),
  plottype = c("curve", "points"),
  linewidth = 1
)
}
\arguments{
\item{cobraplot}{A \code{COBRAPlot} object.}

\item{title}{A character string giving the title of the plot.}

\item{stripsize}{A numeric value giving the size of the strip text, when the
results are stratified by an annotation.}

\item{titlecol}{A character string giving the color of the title.}

\item{pointsize}{A numeric value giving the size of the plot characters.}

\item{xaxisrange}{A numeric vector with two elements, giving the lower and
upper boundary of the x-axis, respectively.}

\item{plottype}{A character vector giving the type of plot to construct. Can
be any combination of the two elements "curve" and "points".}

\item{linewidth}{The line width used for plotting}
}
\value{
A ggplot object
}
\description{
Plot the number of features considered significant vs observed false
discovery rate (FDR), for given adjusted p-value thresholds and/or as curves
traced out by considering all threshold values.
}
\examples{
data(cobradata_example)
cobraperf <- calculate_performance(cobradata_example,
                                   binary_truth = "status",
                                   aspects = c("fdrnbr", "fdrnbrcurve"))
cobraplot <- prepare_data_for_plot(cobraperf, colorscheme = "Dark2",
                                   incltruth = TRUE)
plot_fdrnbrcurve(cobraplot, plottype = c("curve", "points"))
}
\author{
Charlotte Soneson
}
