% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lassoPoints.R
\name{lassoPoints}
\alias{lassoPoints}
\title{Find rows of data within a closed lasso}
\usage{
lassoPoints(df, lasso)
}
\arguments{
\item{df}{A data.frame from which to select rows.}

\item{lasso}{A list containing data from a lasso.}
}
\value{
A subset of rows from \code{df} with coordinates lying within \code{lasso}.
}
\description{
Identify the rows of a data.frame lying within a closed lasso polygon, analogous to \code{\link{brushedPoints}}.
}
\details{
This function uses \code{\link{in.out}} from the \pkg{mgcv} package to identify points within a polygon.
This involves a boundary crossing algorithm that may not be robust in the presence of complex polygons with intersecting edges.
}
\examples{
lasso <- list(coord=rbind(c(0, 0), c(0.5, 0), c(0, 0.5), c(0, 0)),
    closed=TRUE, mapping=list(x="X", y="Y"))
values <- data.frame(X=runif(100), Y=runif(100),
    row.names=sprintf("VALUE_\%i", seq_len(100)))
lassoPoints(values, lasso)

# With faceting information:
lasso <- list(coord=rbind(c(0, 0), c(0.5, 0), c(0, 0.5), c(0, 0)),
    panelvar1="A", panelvar2="B", closed=TRUE,
    mapping=list(x="X", y="Y",
    panelvar1="FacetRow", panelvar2="FacetColumn"))
values <- data.frame(X=runif(100), Y=runif(100),
    FacetRow=sample(LETTERS[1:2], 100, replace=TRUE),
    FacetColumn=sample(LETTERS[1:4], 100, replace=TRUE),
    row.names=sprintf("VALUE_\%i", seq_len(100)))
lassoPoints(values, lasso)

}
\seealso{
\code{\link{brushedPoints}}
}
\author{
Aaron Lun
}
