% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\docType{methods}
\name{output-generics}
\alias{output-generics}
\alias{.renderOutput}
\alias{.defineOutput}
\alias{.generateOutput}
\alias{.exportOutput}
\title{Generics for Panel outputs}
\description{
An overview of the generics for defining the panel outputs, along with recommendations on their implementation.
}
\section{Defining the output element}{

\code{.defineOutput(x)} defines the output element of the panel (e.g., a plot or table widget),
given an instance of a \linkS4class{Panel} subclass in \code{x}.

Methods for this generic are expected to return a HTML element containing the visual output of the panel, such as the return value of \code{\link{plotOutput}} or \code{\link{dataTableOutput}}.
This element will be shown in the \pkg{iSEE} interface above the parameter boxes for \code{x}.
Multiple elements can be returned via a \code{\link{tagList}}.

The IDs of the output elements are expected to be prefixed with the panel name from \code{\link{.getEncodedName}(x)} and an underscore, e.g., \code{"ReducedDimensionPlot1_someOutput"}.
One of the output elements may simply have the ID set to \code{PANEL} alone;
this is usually the case for simple panels with one primary output like a \linkS4class{DotPlot}.
}

\section{Defining the rendered output}{

\code{.renderOutput(x, se, ..., output, pObjects, rObjects)} will create an expression to render the panel's output.
The following arguments are required:
\itemize{
\item \code{x}, an instance of a \linkS4class{Panel} class.
\item \code{se}, a \linkS4class{SummarizedExperiment} object containing the current dataset.
\item \code{...}, further arguments that may be used by specific methods.
\item \code{output}, the Shiny output object from the server function.
\item \code{pObjects}, an environment containing global parameters generated in the \code{\link{iSEE}} app.
\item \code{rObjects}, a reactive list of values generated in the \code{\link{iSEE}} app.
}

It is expected to attach one or more reactive expressions to \code{output} to render the output element(s) defined by \code{.defineOutput}.
This is typically done by calling \pkg{shiny} rendering functions like \code{\link{renderPlot}} or the most appropriate equivalent for the panel's output. 
The return value of this generic is not used; only the side-effect of the reactive output set-up is relevant.

The rendering expression inside the chosen rendering function is expected to:
\enumerate{
\item Call \code{force(rObjects[[PANEL]])}, where \code{PANEL} is the output of \code{\link{.getEncodedName}(x)}.
This ensures that the output is rerendered upon requesting changes in \code{\link{.requestUpdate}}.
\item Call \code{.generateOutput} to generate the output content to be rendered.
\item Fill \code{pObjects$contents[[PANEL]]} with some content related to the displayed output that allows cross-referencing with single/multiple selection structures.
This will be used in other generics like \code{\link{.multiSelectionCommands}} and \code{\link{.singleSelectionValue}} to determine the identity of the selected point(s).
As a result, it is only strictly necessary if the panel is a potential transmitter, as determined by the return value of \code{\link{.multiSelectionDimension}}.
\item Fill \code{pObjects$commands[[PANEL]]} with a character vector of commands required to produce the displayed output.
This should minimally include the commands required to generate \code{pObjects$contents[[PANEL]]};
for plotting panels, the vector should also include code to create the plot.
\item Fill \code{pObjects$varname[[PANEL]]} with a string containing the R expression in \code{pObjects$commands[[PANEL]]} that holds the contents stored in \code{pObjects$contents[[PANEL]]}.
This is used for code reporting, and again, is only strictly necessary if the panel is a potential transmitter.
}

We strongly recommend calling \code{\link{.retrieveOutput}} within the rendering expression, which will automatically perform all of the tasks above, rather than calling \code{\link{.generateOutput}} manually.
By doing so, the only extra work required of the rendering expression is to actually render the output (e.g., by \code{print}ing a \link{ggplot} object).
Of course, the rendering expression must itself be encapsulated by an appropriate rendering function assigned to \code{output}.

Developers should not attempt to modify \code{x} in any rendering expression.
This does not have pass-by-reference semantics and any changes will not propagate to other parts of the application.
Similarly, the rendering expression should treat \code{pObjects$memory} as read-only.
Any adjustment of parameters should be handled elsewhere, e.g., by the observer expressions in \code{\link{.createObservers}}.
}

\section{Generating content}{

\code{.generateOutput(x, se, all_memory, all_contents)} actually generates the panel's output to be used in the rendering expression.
The following arguments are required:
\itemize{
\item \code{x}, an instance of a \linkS4class{Panel} class.
\item \code{se}, a \linkS4class{SummarizedExperiment} object containing the current dataset.
\item \code{all_memory}, a named list containing \linkS4class{Panel} objects parameterizing the current state of the app.
\item \code{all_contents}, a named list containing the contents of each panel.
}

Methods for this generic should return a list containing:
\itemize{
\item \code{contents}, some arbitrary content for the panel (usually a data.frame).
The values therein are used by \code{\link{.multiSelectionCommands}} to determine the multiple row/column selection in \code{x} to be transmitted to other (child) panels.
The app will ensure that the \code{pObjects$contents} of each panel is populated before attempting to render their children. 
\code{contents} may be set to \code{NULL} if \code{x} does not transmit, i.e., \code{\link{.multiSelectionDimension}} returns \code{"none"}.
\item \code{commands}, a list of character vectors of R commands that, when executed, produces the contents of the panel and any displayed output (e.g., a \link{ggplot} object).
Developers should write these commands as if the evaluation environment only contains the SummarizedExperiment \code{se} and ExperimentColorMap \code{colormap}.
It may also contain \code{col_selected}, if a multiple column selection is being transmitted to \code{x};
and possibly \code{row_selected}, if a multiple row selection is being transmitted to \code{x}.
\item \code{varname}, a string specifying the name of the variable in \code{commands} used to generate \code{contents}.
This is used to fulfill code tracking obligations.
If the current panel is not a transmitter, this may be set to \code{NULL} instead.
}
The output list may contain any number of other fields that can be used by \code{\link{.renderOutput}} but are otherwise ignored.

We suggest implementing this method using \code{\link{eval}(\link{parse}(text=...))} calls, which enables easy construction and evaluation of the commands and contents at the same time.
A convenient wrapper for this call is provided by the \code{\link{.textEval}} utility.

The \code{all_memory} and \code{all_contents} arguments are provided for the sole purpose of determining what multiple selections are being received by \code{x}.
We strongly recommend passing them onto \code{\link{.processMultiSelections}} to do the heavy lifting.
It would be unusual and inadvisable to use these arguments for any other information sharing across panels.
}

\section{Exporting content}{

\code{.exportOutput(x, se, all_memory, all_contents)} converts the panel output into a downloadable form.
The following arguments are required:
\itemize{
\item \code{x}, an instance of a \linkS4class{Panel} class.
\item \code{se}, a \linkS4class{SummarizedExperiment} object containing the current dataset.
\item \code{all_memory}, a named list containing \linkS4class{Panel} objects parameterizing the current state of the app.
\item \code{all_contents}, a named list containing the contents of each panel.
}

Methods for this generic should generate appropriate files containing the content of \code{x}.
(For example, plots may create PDFs while tables may create CSV files.)
All files should be created in the working directory at the time of the function call, possibly in further subdirectories.
Each file name should be prefixed with the \code{\link{.getEncodedName}}.
The method itself should return a character vector containing \emph{relative} paths to all newly created files.

To implement this method, we suggest simply passing all arguments onto \code{\link{.generateOutput}} and then converting the output into an appropriate file.
}

\author{
Aaron Lun
}
