% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{visual-parameters-generics}
\alias{visual-parameters-generics}
\alias{.defineVisualColorInterface}
\alias{.defineVisualShapeInterface}
\alias{.defineVisualSizeInterface}
\alias{.defineVisualPointInterface}
\alias{.defineVisualFacetInterface}
\alias{.defineVisualTextInterface}
\alias{.defineVisualOtherInterface}
\alias{.allowableColorByDataChoices}
\alias{.getTooltipUI}
\title{Generics for visual DotPlot parameters}
\description{
These generics allow subclasses to override the user interface elements controlling visual parameters of \linkS4class{DotPlot} panels.
}
\section{Interface definition}{

In all of the code snippets below, \code{x} is a \linkS4class{Panel} instance and \code{se} is the \linkS4class{SummarizedExperiment} object.
\itemize{
\item \code{.defineVisualColorInterface(x, se, select_info)} should return a HTML tag definition that contains UI input elements controlling the \code{color} aesthetic of \code{ggplot} objects.
Here, \code{select_info} is a list of two character vectors named \code{row} and \code{column}, which specifies the names of panels available for transmitting single selections on the rows/columns respectively.
A common use case would involve adding elements to change the default color of the points or to color by a chosen metadata field/assay values.
\item \code{.defineVisualShapeInterface(x, se)} should return a HTML tag definition that contains UI input elements controlling the \code{shape} aesthetic of \code{ggplot} objects.
A common use case would involve adding elements to change the shape of each point according to a chosen metadata field.
\item \code{.defineVisualSizeInterface(x, se)} should return a HTML tag definition that contains UI input elements controlling the \code{size} aesthetic of \code{ggplot} objects.
A common use case would involve adding elements to change the size of each point according to a chosen metadata field or assay values.
\item \code{.defineVisualPointInterface(x, se)} should return a HTML tag definition that contains UI input elements controlling other aesthetics of \code{ggplot} objects.
This might include controlling the transparency or downsampling.
\item \code{.defineVisualFacetInterface(x, se)} should return a HTML tag definition that contains UI input elements controlling the \code{facet_grid} applied to \code{ggplot} objects.
This typically involves providing UI elements to choose the metadata variables to use for faceting.
\item \code{.defineVisualTextInterface(x, se)} should return a HTML tag definition that contains UI input elements controlling the appearance of non-data text elements of \code{ggplot} objects.
This typically involves matters such as the font size and legend position.
\item \code{.defineVisualOtherInterface(x)} should a HTML tag definition that contains UI inputs elements to display in the \code{"Other"} section of the visual parameters.
This is a grab-bag of other parameters that don't fit into the more defined categories above.
}

A method for any of these generics may also return \code{NULL}, in which case the corresponding section of the visual parameter box is completely hidden.

All of these generics are called by \code{\link{.defineInterface}} for DotPlot subclasses.
Developers of subclasses can simply specialize these generics to change the UI instead of reimplementing \code{.defineInterface} itself.

When implementing methods for these generics, it is a good idea to make use of information precomputed by \code{\link{.cacheCommonInfo}}.
For example, \code{\link{.cacheCommonInfo,ColumnDotPlot-method}} will add vectors specifying whether a variable in the \code{\link{colData}} is valid and discrete or continuous.
}

\section{Controlling \code{ColorBy*Data} choices}{

\code{.allowableColorByDataChoices(x, se)} should return a character vector of the allowable row/column data variables to use 
when \code{ColorBy} is set to \code{"Row data"} or \code{"Column data"} for \linkS4class{RowDotPlot}s and \linkS4class{ColumnDotPlot}s, respectively.
The default method will use all available (atomic) variables, but subclasses can specialize this to only allow, e.g., continuous or discrete variables.
}

\section{Controlling hover choices}{

\code{.getTooltipUI(x, se, name)} should return an \code{HTML} tag definition representing information to display in the tooltip that is displayed in \code{DotPlot} panels when hovering over a data point.
The data point is identified by \code{name}, its \code{rownames} or \code{colnames} value in \code{se}.
}

\author{
Kevin Rue-Albrecht
}
