% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DynamicMarkerTable.R
\name{DynamicMarkerTable-class}
\alias{DynamicMarkerTable-class}
\alias{DynamicMarkerTable}
\alias{DifferentialStatisticsTable}
\alias{initialize,DynamicMarkerTable-method}
\alias{.fullName,DynamicMarkerTable-method}
\alias{.panelColor,DynamicMarkerTable-method}
\alias{.defineDataInterface,DynamicMarkerTable-method}
\alias{.hideInterface,DynamicMarkerTable-method}
\alias{.generateTable,DynamicMarkerTable-method}
\alias{.createObservers,DynamicMarkerTable-method}
\alias{.cacheCommonInfo,DynamicMarkerTable-method}
\alias{.refineParameters,DynamicMarkerTable-method}
\alias{.multiSelectionInvalidated,DynamicMarkerTable-method}
\alias{.definePanelTour,DynamicMarkerTable-method}
\title{Dynamic marker table}
\description{
A table that dynamically identifies marker genes for a selected subset of samples.
Comparisons are made between the active selection in the transmitting panel
and (i) all non-selected points, if no saved selections are available;
or (ii) each subset of points in each saved selection.
}
\section{Slot overview}{

The following slots control the test procedure:
\itemize{
\item \code{LogFC}, a numeric scalar indicating the log-fold change threshold to test against.
Defaults to zero.
\item \code{TestMethod}, string indicating the test to use (based on the \code{findMarkers} function from \pkg{scran}).
This can be \code{"t"} (default), \code{"wilcox"} or \code{"binom"}.
\item \code{Assay}, string indicating the assay to use for testing.
Defaults to the first named assay in the SummarizedExperiment.
}

The following slots control the rendered table:
\itemize{
\item \code{ExtraFields}, a character vector containing names of \code{\link{rowData}} columns to be included in the table.
Set to the output of \code{\link{getTableExtraFields}}.
This cannot be changed once the application starts.
}

In addition, this class inherits all slots from its parent \linkS4class{RowTable},
\linkS4class{Table} and \linkS4class{Panel} classes.
}

\section{Constructor}{

\code{DynamicMarkerTable(...)} creates an instance of a DynamicMarkerTable class,
where any slot and its value can be passed to \code{...} as a named argument.
}

\section{Supported methods}{

In the following code snippets, \code{x} is an instance of a \linkS4class{DynamicMarkerTable} class.
Refer to the documentation for each method for more details on the remaining arguments.

For setting up data values:
\itemize{
\item \code{\link{.cacheCommonInfo}(x)} adds a \code{"DynamicMarkerTable"} entry
containing \code{valid.assay.names} and \code{valid.rowdata.names}.
This will also call the equivalent \linkS4class{RowTable} method.
\item \code{\link{.refineParameters}(x, se)} returns \code{x} after setting \code{"Assay"} to the first valid value.
This will also call the equivalent \linkS4class{RowTable} method for further refinements to \code{x}.
If valid assay names are not available, \code{NULL} is returned instead.
Any \code{"ExtraFields"} are intersected with the valid \code{rowData} names.
}

For defining the interface:
\itemize{
\item \code{\link{.defineDataInterface}(x, se, select_info)} returns a list of interface elements for manipulating all slots described above.
\item \code{\link{.panelColor}(x)} will return the specified default color for this panel class.
\item \code{\link{.fullName}(x)} will return \code{"Dynamic marker table"}.
\item \code{\link{.hideInterface}(x)} will return \code{TRUE} for UI elements related to multiple row selections,
otherwise calling the method for \linkS4class{RowTable}.
}

For monitoring reactive expressions:
\itemize{
\item \code{\link{.createObservers}(x, se, input, session, pObjects, rObjects)} sets up observers for all new slots described above, as well as in the parent classes via the \linkS4class{RowTable} method.
}

For creating the table:
\itemize{
\item \code{\link{.generateTable}(x, envir)} will create a data.frame of newly computed statistics in \code{envir}.
The method will return the commands required to do so.
}

For documentation:
\itemize{
\item \code{\link{.definePanelTour}(x)} returns an data.frame containing the steps of a panel-specific tour.
}
}

\examples{
library(scRNAseq)
library(scater)

sce <- ReprocessedAllenData(assays="tophat_counts")
sce <- logNormCounts(sce, exprs_values="tophat_counts")
sce <- runPCA(sce, ncomponents=4)
sce <- runTSNE(sce)

dst <- DynamicMarkerTable(PanelId=1L, PanelWidth=8L,
    ColumnSelectionSource="ReducedDimensionPlot1")

rdp <- ReducedDimensionPlot(PanelId=1L,
    ColorByFeatureSource="DynamicMarkerTable1")

if (interactive()) {
    iSEE(sce, initial=list(rdp, dst))
}

}
