% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globals.R
\name{getTableExtraFields}
\alias{getTableExtraFields}
\alias{setTableExtraFields}
\title{Global extra table fields}
\usage{
getTableExtraFields()

setTableExtraFields(value)
}
\arguments{
\item{value}{A character vector containing the names of extra fields to include.}
}
\value{
\code{getTableExtraFields} returns the current global extra table fields.

\code{setTableExtraFields} will set the current global extra table fields and return \code{NULL} invisibly.
}
\description{
Get or set the names of the extra fields to include in a table.
}
\details{
These utilities allow users to easily set the feature set commands for all \linkS4class{DynamicMarkerTable}s at once.
Any global settings only take effect (i) during setup of the \code{\link{iSEE}} application
and (ii) if the first \linkS4class{DynamicMarkerTable} does not have an existing values in the \code{"TableExtraFields"} slots.
}
\examples{
old <- getTableExtraFields()

setTableExtraFields(LETTERS)
getTableExtraFields()

setTableExtraFields(old)
}
\author{
Aaron Lun
}
