% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregateNeighbors.R
\name{aggregateNeighbors}
\alias{aggregateNeighbors}
\title{Function to aggregate all neighbors of each cell.}
\usage{
aggregateNeighbors(
  object,
  colPairName,
  aggregate_by = c("metadata", "expression"),
  count_by = NULL,
  proportions = TRUE,
  assay_type = NULL,
  subset_row = NULL,
  statistic = c("mean", "median", "sd", "var"),
  name = NULL
)
}
\arguments{
\item{object}{a \code{SingleCellExperiment} or \code{SpatialExperiment}
object}

\item{colPairName}{single character indicating the \code{colPair(object)}
entry containing the neighbor information.}

\item{aggregate_by}{character specifying whether the neighborhood should be
summarized by cellular features stored in \code{colData(object)}
(\code{aggregate_by = "metdata"}) or by marker expression of the
neighboring cells (\code{aggregate_by = "expression"}).}

\item{count_by}{for \code{summarize_by = "metadata"}, a single character
specifying the \code{colData(object)} entry containing the cellular
metadata that should be summarized across each cell's neighborhood.}

\item{proportions}{single logical indicating whether aggregated metadata
should be returned in form of proportions instead of absolute counts.}

\item{assay_type}{for \code{summarize_by = "expression"}, single character
indicating the assay slot to use.}

\item{subset_row}{for \code{summarize_by = "expression"}, an integer, logical
or character vector specifying the features to use. If NULL, defaults to
all features.}

\item{statistic}{for \code{summarize_by = "expression"}, a single character
specifying the statistic to be used for summarizing the expression values
across all neighboring cells. Supported entries are "mean", "median", "sd",
"var". Defaults to "mean" if not specified.}

\item{name}{single character specifying the name of the data frame to be
saved in the \code{colData(object)}. Defaults to "aggregatedNeighbors" when
\code{summarize_by = "metadata"} or "{statistic}_aggregatedExpression" when
\code{summarize_by = "expression"}.}
}
\value{
returns an object of \code{class(object)} containing the aggregated
values in form of a \code{DataFrame} object in
\code{colData(object)[[name]]}.
}
\description{
Function to summarize categorical or expression values of all
neighbors of each cell.
}
\examples{
library(cytomapper)
data(pancreasSCE)

sce <- buildSpatialGraph(pancreasSCE, img_id = "ImageNb", 
                         type = "knn", k = 3)
                         
# Aggregating neighboring cell-types
sce <- aggregateNeighbors(sce, colPairName = "knn_interaction_graph",
                         aggregate_by = "metadata",
                         count_by = "CellType")
sce$aggregatedNeighbors

# Aggregating neighboring expression values
sce <- aggregateNeighbors(sce, colPairName = "knn_interaction_graph",
                         aggregate_by = "expression",
                         assay_type = "exprs",
                         statistic = "mean")
sce$mean_aggregatedExpression
  
}
\author{
Daniel Schulz (\email{daniel.schulz@uzh.ch})
}
